/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import java.util.Objects;

public class Vector3f {
    public final float x;
    public final float y;
    public final float z;

    public Vector3f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(float[] array) {
        if (array.length <= 0) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            return;
        }
        this.x = array[0];
        if (array.length <= 1) {
            this.y = 0.0f;
            this.z = 0.0f;
            return;
        }
        this.y = array[1];
        this.z = array.length > 2 ? array[2] : 0.0f;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector3f) {
            Vector3f vec = (Vector3f)obj;
            return this.x == vec.x && this.y == vec.y && this.z == vec.z;
        }
        if (obj instanceof Vector3d) {
            Vector3d vec = (Vector3d)obj;
            return (double)this.x == vec.x && (double)this.y == vec.y && (double)this.z == vec.z;
        }
        if (obj instanceof Vector3i) {
            Vector3i vec = (Vector3i)obj;
            return (double)this.x == (double)vec.x && (double)this.y == (double)vec.y && (double)this.z == (double)vec.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public Vector3f add(float x, float y, float z) {
        return new Vector3f(this.x + x, this.y + y, this.z + z);
    }

    public Vector3f add(Vector3f other) {
        return this.add(other.x, other.y, other.z);
    }

    public Vector3f offset(BlockFace face) {
        return this.add(face.getModX(), face.getModY(), face.getModZ());
    }

    public Vector3f subtract(float x, float y, float z) {
        return new Vector3f(this.x - x, this.y - y, this.z - z);
    }

    public Vector3f subtract(Vector3f other) {
        return this.subtract(other.x, other.y, other.z);
    }

    public Vector3f multiply(float x, float y, float z) {
        return new Vector3f(this.x * x, this.y * y, this.z * z);
    }

    public Vector3f multiply(Vector3f other) {
        return this.multiply(other.x, other.y, other.z);
    }

    public Vector3f multiply(float value) {
        return this.multiply(value, value, value);
    }

    public Vector3f crossProduct(Vector3f other) {
        float newX = this.y * other.z - other.y * this.z;
        float newY = this.z * other.x - other.z * this.x;
        float newZ = this.x * other.y - other.x * this.y;
        return new Vector3f(newX, newY, newZ);
    }

    public float dot(Vector3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3f with(Float x, Float y, Float z) {
        return new Vector3f(x == null ? this.x : x.floatValue(), y == null ? this.y : y.floatValue(), z == null ? this.z : z.floatValue());
    }

    public Vector3f withX(float x) {
        return new Vector3f(x, this.y, this.z);
    }

    public Vector3f withY(float y) {
        return new Vector3f(this.x, y, this.z);
    }

    public Vector3f withZ(float z) {
        return new Vector3f(this.x, this.y, z);
    }

    public String toString() {
        return "X: " + this.x + ", Y: " + this.y + ", Z: " + this.z;
    }

    public static Vector3f zero() {
        return new Vector3f();
    }
}

