/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.stats.Statistics;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.AdventureNBTSerializer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.json.JSONOptions;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import com.google.gson.JsonElement;

public class AdventureSerializer {
    private static GsonComponentSerializer GSON;
    private static LegacyComponentSerializer LEGACY;
    private static AdventureNBTSerializer NBT;

    public static GsonComponentSerializer getGsonSerializer() {
        if (GSON == null) {
            ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
            GSON = GsonComponentSerializer.builder().editOptions(builder -> {
                boolean is_1_20_3_or_new = version.isNewerThanOrEquals(ServerVersion.V_1_20_3);
                builder.value(JSONOptions.EMIT_RGB, version.isNewerThanOrEquals(ServerVersion.V_1_16) && !PacketEvents.getAPI().getSettings().shouldDownsampleColors());
                builder.value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.BOTH);
                builder.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, is_1_20_3_or_new);
                builder.value(JSONOptions.VALIDATE_STRICT_EVENTS, is_1_20_3_or_new);
                builder.value(JSONOptions.SHOW_ITEM_HOVER_DATA_MODE, JSONOptions.ShowItemHoverDataMode.EMIT_EITHER);
            }).legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).showAchievementToComponent(input -> Statistics.getById(input).display()).build();
        }
        return GSON;
    }

    @Deprecated
    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        return AdventureSerializer.getLegacySerializer();
    }

    public static LegacyComponentSerializer getLegacySerializer() {
        if (LEGACY == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder();
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
                builder = builder.hexColors();
            }
            LEGACY = builder.build();
        }
        return LEGACY;
    }

    public static AdventureNBTSerializer getNBTSerializer() {
        if (NBT == null) {
            NBT = new AdventureNBTSerializer(PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16) || PacketEvents.getAPI().getSettings().shouldDownsampleColors());
        }
        return NBT;
    }

    public static String asVanilla(Component component) {
        return AdventureSerializer.getLegacySerializer().serialize(component);
    }

    public static Component fromLegacyFormat(String legacyMessage) {
        return AdventureSerializer.getLegacySerializer().deserializeOrNull(legacyMessage);
    }

    public static String toLegacyFormat(Component component) {
        return (String)AdventureSerializer.getLegacySerializer().serializeOrNull(component);
    }

    public static Component parseComponent(String json) {
        return AdventureSerializer.getGsonSerializer().deserializeOrNull(json);
    }

    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.getGsonSerializer().deserializeFromTree(json);
    }

    public static String toJson(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serializeOrNull(component);
    }

    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.getGsonSerializer().serializeToTree(component);
    }

    public static Component fromNbt(NBT nbt) {
        return AdventureSerializer.getNBTSerializer().deserialize(nbt);
    }

    public static NBT toNbt(Component component) {
        return AdventureSerializer.getNBTSerializer().serialize(component);
    }
}

