/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.ChatType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariant;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariants;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.banner.BannerPattern;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.banner.BannerPatterns;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.instrument.Instrument;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.instrument.Instruments;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.jukebox.IJukeboxSong;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.jukebox.JukeboxSongs;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.trimmaterial.TrimMaterial;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.trimmaterial.TrimMaterials;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.trimpattern.TrimPattern;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.trimpattern.TrimPatterns;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTList;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.biome.Biome;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.biome.Biomes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DamageType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DamageTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.dimension.DimensionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.painting.PaintingVariant;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.painting.PaintingVariants;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.IRegistry;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.SimpleRegistry;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.SimpleTypesBuilderData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import ac.grim.grimac.shaded.jetbrains.annotations.ApiStatus;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

@ApiStatus.Internal
public final class SynchronizedRegistriesHandler {
    private static final boolean FORCE_PER_USER_REGISTRIES = Boolean.getBoolean("packetevents.force-per-user-registries");
    private static final Map<ResourceLocation, RegistryEntry<?>> REGISTRY_KEYS = new HashMap();

    private SynchronizedRegistriesHandler() {
    }

    @Nullable
    public static RegistryEntry<?> getRegistryEntry(ResourceLocation registryKey) {
        return REGISTRY_KEYS.get(registryKey);
    }

    public static void handleRegistry(User user, ClientVersion version, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, version);
        SynchronizedRegistriesHandler.handleRegistry(user, version, registryName, elements, cacheKey);
    }

    public static void handleRegistry(User user, ClientVersion version, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements, Object cacheKey) {
        RegistryEntry<?> registryData = REGISTRY_KEYS.get(registryName);
        if (registryData == null) {
            return;
        }
        SimpleRegistry<?> syncedRegistry = FORCE_PER_USER_REGISTRIES || cacheKey == null ? registryData.createFromElements(elements, version) : registryData.computeSyncedRegistry(cacheKey, () -> registryData.createFromElements(elements, version));
        user.putRegistry(syncedRegistry);
    }

    public static void handleLegacyRegistries(User user, ClientVersion version, NBTCompound registryData) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, version);
        for (NBT tag : registryData.getTags().values()) {
            if (tag instanceof NBTList) {
                NBTList list = (NBTList)tag;
                SynchronizedRegistriesHandler.handleRegistry(user, version, DimensionTypes.getRegistry().getRegistryKey(), WrapperConfigServerRegistryData.RegistryElement.convertNbt(list), cacheKey);
                continue;
            }
            NBTCompound compound = (NBTCompound)tag;
            ResourceLocation registryName = new ResourceLocation(compound.getStringTagValueOrThrow("type"));
            NBTList<NBTCompound> nbtElements = compound.getCompoundListTagOrNull("value");
            if (nbtElements == null) continue;
            SynchronizedRegistriesHandler.handleRegistry(user, version, registryName, WrapperConfigServerRegistryData.RegistryElement.convertNbt(nbtElements), cacheKey);
        }
    }

    static {
        Stream.of(new RegistryEntry<Biome>(Biomes.getRegistry(), Biome::decode), new RegistryEntry<ChatType>(ChatTypes.getRegistry(), ChatType::decode), new RegistryEntry<TrimPattern>(TrimPatterns.getRegistry(), TrimPattern::decode), new RegistryEntry<TrimMaterial>(TrimMaterials.getRegistry(), TrimMaterial::decode), new RegistryEntry<WolfVariant>(WolfVariants.getRegistry(), WolfVariant::decode), new RegistryEntry<PaintingVariant>(PaintingVariants.getRegistry(), PaintingVariant::decode), new RegistryEntry<DimensionType>(DimensionTypes.getRegistry(), DimensionType::decode), new RegistryEntry<DamageType>(DamageTypes.getRegistry(), DamageType::decode), new RegistryEntry<BannerPattern>(BannerPatterns.getRegistry(), BannerPattern::decode), new RegistryEntry<EnchantmentType>(EnchantmentTypes.getRegistry(), EnchantmentType::decode), new RegistryEntry<IJukeboxSong>(JukeboxSongs.getRegistry(), IJukeboxSong::decode), new RegistryEntry<Instrument>(Instruments.getRegistry(), Instrument::decode)).forEach(entry -> REGISTRY_KEYS.put(entry.getRegistryKey(), (RegistryEntry<?>)entry));
    }

    @ApiStatus.Internal
    public static final class RegistryEntry<T extends MappedEntity & CopyableEntity<T>> {
        private final IRegistry<T> baseRegistry;
        private final NbtEntryDecoder<T> decoder;
        private final Map<Object, SimpleRegistry<T>> syncedRegistries = new ConcurrentHashMap<Object, SimpleRegistry<T>>(2);

        public RegistryEntry(IRegistry<T> baseRegistry, NbtEntryDecoder<T> decoder) {
            this.baseRegistry = baseRegistry;
            this.decoder = decoder;
        }

        @Nullable
        public SimpleRegistry<T> getSyncedRegistry(Object key) {
            return this.syncedRegistries.get(key);
        }

        public SimpleRegistry<T> computeSyncedRegistry(Object key, Supplier<SimpleRegistry<?>> registry) {
            return this.syncedRegistries.computeIfAbsent(key, $ -> (SimpleRegistry)registry.get());
        }

        private void handleElement(SimpleRegistry<T> registry, WrapperConfigServerRegistryData.RegistryElement element, int id, ClientVersion version) {
            MappedEntity value;
            Object copiedBaseEntry;
            ResourceLocation elementName = element.getId();
            T baseEntry = this.baseRegistry.getByName(elementName);
            SimpleTypesBuilderData data = new SimpleTypesBuilderData(elementName, id);
            Object z = copiedBaseEntry = baseEntry == null ? null : (Object)((CopyableEntity)baseEntry).copy(data);
            if (element.getData() != null && !((DeepComparableEntity)((Object)(value = (MappedEntity)this.decoder.decode(element.getData(), version, data)))).deepEquals(copiedBaseEntry)) {
                registry.define(elementName, id, value);
                return;
            }
            if (copiedBaseEntry != null) {
                registry.define(elementName, id, copiedBaseEntry);
                return;
            }
            PacketEvents.getAPI().getLogger().warning("Unknown registry entry " + elementName + " for " + this.getRegistryKey());
        }

        public SimpleRegistry<T> createFromElements(List<WrapperConfigServerRegistryData.RegistryElement> elements, ClientVersion version) {
            SimpleRegistry registry = new SimpleRegistry(this.getRegistryKey());
            for (int id = 0; id < elements.size(); ++id) {
                WrapperConfigServerRegistryData.RegistryElement element = elements.get(id);
                this.handleElement(registry, element, id, version);
            }
            return registry;
        }

        public ResourceLocation getRegistryKey() {
            return this.baseRegistry.getRegistryKey();
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface NbtEntryDecoder<T> {
        public T decode(NBT var1, ClientVersion var2, @Nullable TypesBuilderData var3);
    }
}

