/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.anticheat;

import ac.grim.grimac.api.events.GrimJoinEvent;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.GeyserUtil;
import ac.grim.grimac.utils.anticheat.MultiLibUtil;
import ac.grim.grimac.utils.floodgate.FloodgateUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerDataManager {
    private final ConcurrentHashMap<User, GrimPlayer> playerDataMap = new ConcurrentHashMap();
    public final Collection<User> exemptUsers = Collections.synchronizedCollection(new HashSet());

    public GrimPlayer getPlayer(Player player) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18) && MultiLibUtil.isExternalPlayer(player)) {
            return null;
        }
        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
        return this.playerDataMap.get(user);
    }

    public boolean shouldCheck(User user) {
        if (this.exemptUsers.contains(user)) {
            return false;
        }
        if (!ChannelHelper.isOpen(user.getChannel())) {
            return false;
        }
        if (user.getUUID() != null) {
            if (GeyserUtil.isGeyserPlayer(user.getUUID()) || FloodgateUtil.isFloodgatePlayer(user.getUUID())) {
                this.exemptUsers.add(user);
                return false;
            }
            Player player = Bukkit.getPlayer((UUID)user.getUUID());
            if (player != null && player.hasPermission("grim.exempt")) {
                this.exemptUsers.add(user);
                return false;
            }
            if (user.getUUID().toString().startsWith("00000000-0000-0000-0009")) {
                this.exemptUsers.add(user);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public GrimPlayer getPlayer(User user) {
        return this.playerDataMap.get(user);
    }

    public void addUser(User user) {
        if (this.shouldCheck(user)) {
            GrimPlayer player = new GrimPlayer(user);
            this.playerDataMap.put(user, player);
            Bukkit.getPluginManager().callEvent((Event)new GrimJoinEvent(player));
        }
    }

    public GrimPlayer remove(User user) {
        return this.playerDataMap.remove(user);
    }

    public Collection<GrimPlayer> getEntries() {
        return this.playerDataMap.values();
    }

    public int size() {
        return this.playerDataMap.size();
    }
}

