/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.change;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.utils.change.BlockModification;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlayerBlockHistory {
    public final Deque<BlockModification> modificationQueue = new ConcurrentLinkedDeque<BlockModification>();

    public void add(BlockModification modification) {
        this.modificationQueue.add(modification);
    }

    public List<BlockModification> getRecentModifications(Predicate<BlockModification> filter) {
        return this.modificationQueue.stream().filter(filter).collect(Collectors.toList());
    }

    public List<WrappedBlockState> getBlockStates(Predicate<BlockModification> filter) {
        return this.modificationQueue.stream().filter(filter).flatMap(mod -> Stream.of(mod.oldBlockContents(), mod.newBlockContents())).collect(Collectors.toList());
    }

    public List<WrappedBlockState> getPreviousBlockStates(Predicate<BlockModification> filter) {
        return this.modificationQueue.stream().filter(filter).map(BlockModification::oldBlockContents).collect(Collectors.toList());
    }

    public List<WrappedBlockState> getResultingBlockStates(Predicate<BlockModification> filter) {
        return this.modificationQueue.stream().filter(filter).map(BlockModification::newBlockContents).collect(Collectors.toList());
    }

    public void cleanup(int maxTick) {
        while (!this.modificationQueue.isEmpty() && maxTick - this.modificationQueue.peekFirst().tick() > 0) {
            this.modificationQueue.removeFirst();
        }
    }

    public int size() {
        return this.modificationQueue.size();
    }

    public void clear() {
        this.modificationQueue.clear();
    }
}

