/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.ComplexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.HexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.HitBoxFactory;
import ac.grim.grimac.utils.collisions.datatypes.NoCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public enum RaycastData {
    HOPPER((player, item, version, data, isTarget, x, y, z) -> {
        HexCollisionBox insideShape = new HexCollisionBox(2.0, 11.0, 2.0, 14.0, 16.0, 14.0);
        switch (data.getFacing()) {
            case NORTH: {
                new ComplexCollisionBox(insideShape, new HexCollisionBox(6.0, 8.0, 0.0, 10.0, 10.0, 4.0));
            }
            case SOUTH: {
                new ComplexCollisionBox(insideShape, new HexCollisionBox(6.0, 8.0, 12.0, 10.0, 10.0, 16.0));
            }
            case WEST: {
                new ComplexCollisionBox(insideShape, new HexCollisionBox(0.0, 8.0, 6.0, 4.0, 10.0, 10.0));
            }
            case EAST: {
                new ComplexCollisionBox(insideShape, new HexCollisionBox(12.0, 8.0, 6.0, 16.0, 10.0, 10.0));
            }
        }
        return insideShape;
    }, StateTypes.HOPPER),
    CAULDRON((player, item, version, data, isTarget, x, y, z) -> new HexCollisionBox(2.0, 4.0, 2.0, 14.0, 16.0, 14.0), BlockTags.CAULDRONS.getStates().toArray(new StateType[0])),
    FULL_BLOCK((player, item, version, data, isTarget, x, y, z) -> new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true), StateTypes.COMPOSTER, StateTypes.SCAFFOLDING);

    private static final Map<StateType, RaycastData> lookup;
    private final StateType[] materials;
    private CollisionBox box;
    private HitBoxFactory dynamic;

    private RaycastData(CollisionBox box, StateType ... materials) {
        this.box = box;
        HashSet<StateType> mList = new HashSet<StateType>(Arrays.asList(materials));
        mList.remove(null);
        this.materials = mList.toArray(new StateType[0]);
    }

    private RaycastData(HitBoxFactory dynamic, StateType ... materials) {
        this.dynamic = dynamic;
        HashSet<StateType> mList = new HashSet<StateType>(Arrays.asList(materials));
        mList.remove(null);
        this.materials = mList.toArray(new StateType[0]);
    }

    public static RaycastData getData(StateType material) {
        return lookup.get(material);
    }

    @Nullable
    public static CollisionBox getBlockHitbox(GrimPlayer player, StateType heldItem, ClientVersion version, WrappedBlockState block, int x, int y, int z) {
        RaycastData data = RaycastData.getData(block.getType());
        if (data == null) {
            return NoCollisionBox.INSTANCE;
        }
        if (data.box != null) {
            return data.box.copy().offset(x, y, z);
        }
        HitBoxFactory hitBoxFactory = data.dynamic;
        CollisionBox collisionBox = hitBoxFactory.fetch(player, heldItem, version, block, false, x, y, z);
        collisionBox.offset(x, y, z);
        return collisionBox;
    }

    static {
        lookup = new HashMap<StateType, RaycastData>();
        for (RaycastData data2 : RaycastData.values()) {
            for (StateType type : data2.materials) {
                lookup.put(type, data2);
            }
        }
    }
}

