/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.data.packetentity;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.data.attribute.ValuedAttribute;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import java.util.UUID;

public class PacketEntityHorse
extends PacketEntityTrackXRot {
    public boolean isRearing = false;
    public boolean hasSaddle = false;
    public boolean isTame = false;

    public PacketEntityHorse(GrimPlayer player, UUID uuid, EntityType type, double x, double y, double z, float xRot) {
        super(player, uuid, type, x, y, z, xRot);
        this.setAttribute(Attributes.STEP_HEIGHT, 1.0);
        boolean preAttribute = player.getClientVersion().isOlderThan(ClientVersion.V_1_20_5);
        this.trackAttribute(ValuedAttribute.ranged(Attributes.JUMP_STRENGTH, 0.7, 0.0, preAttribute ? 2.0 : 32.0).withSetRewriter((oldValue, newValue) -> {
            if (preAttribute && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                return oldValue;
            }
            return newValue;
        }));
        this.trackAttribute(ValuedAttribute.ranged(Attributes.MOVEMENT_SPEED, 0.225f, 0.0, 1024.0));
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.CHESTED_HORSE)) {
            this.setAttribute(Attributes.JUMP_STRENGTH, 0.5);
            this.setAttribute(Attributes.MOVEMENT_SPEED, 0.175f);
        }
        if (type == EntityTypes.ZOMBIE_HORSE || type == EntityTypes.SKELETON_HORSE) {
            this.setAttribute(Attributes.MOVEMENT_SPEED, 0.2f);
        }
    }
}

