/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.data.packetentity;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Direction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.Axis;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.math.GrimMath;
import java.util.UUID;

public class PacketEntityPainting
extends PacketEntity {
    private final Direction side;
    public SimpleCollisionBox paintingHitBox;
    private int width;
    private int height;

    public PacketEntityPainting(GrimPlayer player, UUID uuid, double x, double y, double z, Direction direction) {
        super(player, uuid, EntityTypes.PAINTING, x, y, z);
        this.paintingHitBox = new SimpleCollisionBox(this.trackedServerPosition.getPos().x, this.trackedServerPosition.getPos().y, this.trackedServerPosition.getPos().z, this.trackedServerPosition.getPos().x, this.trackedServerPosition.getPos().y, this.trackedServerPosition.getPos().z);
        this.side = direction;
    }

    public SimpleCollisionBox calculateBoundingBoxDimensions(int width, int height) {
        if (this.width == width && this.height == height) {
            return this.paintingHitBox;
        }
        this.width = width;
        this.height = height;
        float f = 0.46875f;
        Vector3d trackedServerPositionVector = this.trackedServerPosition.getPos();
        Vector3i attachedBlockPos = new Vector3i(GrimMath.floor(trackedServerPositionVector.getX()), GrimMath.floor(trackedServerPositionVector.getY()), GrimMath.floor(trackedServerPositionVector.getZ()));
        Vector3d vec3d = attachedBlockPos.toVector3d().add(0.5, 0.5, 0.5);
        vec3d = this.offset(vec3d, this.side, -f);
        double d = this.getOffset(width);
        double e = this.getOffset(height);
        Direction direction = this.rotateYCounterclockwise(this.side);
        Vector3d vec3d2 = this.offset(vec3d, direction, d);
        vec3d2 = this.offset(vec3d2, Direction.UP, e);
        Axis axis = this.getAxis(this.side);
        double g = axis == Axis.X ? 0.0625 : (double)width;
        double h = height;
        double i = axis == Axis.Z ? 0.0625 : (double)width;
        SimpleCollisionBox box = new SimpleCollisionBox(vec3d2.getX() - g / 2.0, vec3d2.getY() - h / 2.0, vec3d2.getZ() - i / 2.0, vec3d2.getX() + g / 2.0, vec3d2.getY() + h / 2.0, vec3d2.getZ() + i / 2.0);
        return box;
    }

    private double getOffset(int length) {
        return length % 2 == 0 ? 0.5 : 0.0;
    }

    private Direction rotateYCounterclockwise(Direction side) {
        switch (side) {
            case NORTH: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    private Vector3d offset(Vector3d vector3d, Direction side, double value) {
        Vector3i vec3i = this.getDirectionVector(side);
        return new Vector3d(vector3d.getX() + value * (double)vec3i.getX(), vector3d.getY() + value * (double)vec3i.getY(), vector3d.getZ() + value * (double)vec3i.getZ());
    }

    private Vector3i getDirectionVector(Direction side) {
        switch (side) {
            case DOWN: {
                return new Vector3i(0, -1, 0);
            }
            case UP: {
                return new Vector3i(0, 1, 0);
            }
            case NORTH: {
                return new Vector3i(0, 0, -1);
            }
            case SOUTH: {
                return new Vector3i(0, 0, 1);
            }
            case WEST: {
                return new Vector3i(-1, 0, 0);
            }
            case EAST: {
                return new Vector3i(1, 0, 0);
            }
        }
        throw new IllegalStateException("Impossible direction: " + (Object)((Object)side));
    }

    private Axis getAxis(Direction direction) {
        switch (this.side) {
            case DOWN: 
            case UP: {
                return Axis.Y;
            }
            case NORTH: 
            case SOUTH: {
                return Axis.Z;
            }
            case WEST: 
            case EAST: {
                return Axis.X;
            }
        }
        throw new IllegalStateException("Impossible direction: " + (Object)((Object)this.side));
    }

    public Direction getSide() {
        return this.side;
    }

    public SimpleCollisionBox getPaintingHitBox() {
        return this.paintingHitBox;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

