/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PositionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.data.CooldownData;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompensatedCooldown
extends Check
implements PositionCheck {
    private final ConcurrentHashMap<ItemType, CooldownData> itemCooldownMap = new ConcurrentHashMap();

    public CompensatedCooldown(GrimPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onPositionUpdate(PositionUpdate positionUpdate) {
        Iterator<Map.Entry<ItemType, CooldownData>> it = this.itemCooldownMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemType, CooldownData> entry = it.next();
            if (entry.getValue().getTransaction() < this.player.lastTransactionReceived.get()) {
                entry.getValue().tick();
            }
            if (entry.getValue().getTicksRemaining() > 0) continue;
            it.remove();
        }
    }

    public boolean hasMaterial(ItemType item) {
        return this.itemCooldownMap.containsKey(item);
    }

    public void addCooldown(ItemType item, int cooldown, int transaction) {
        if (cooldown == 0) {
            this.removeCooldown(item);
            return;
        }
        this.itemCooldownMap.put(item, new CooldownData(cooldown, transaction));
    }

    public void removeCooldown(ItemType item) {
        this.itemCooldownMap.remove(item);
    }
}

