/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.InteractionHand;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenHorseWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotConversionUtil;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.inventory.EquipmentType;
import ac.grim.grimac.utils.inventory.Inventory;
import ac.grim.grimac.utils.inventory.inventory.AbstractContainerMenu;
import ac.grim.grimac.utils.inventory.inventory.MenuType;
import ac.grim.grimac.utils.inventory.inventory.NotImplementedMenu;
import ac.grim.grimac.utils.lists.CorrectingPlayerInventoryStorage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public class CompensatedInventory
extends Check
implements PacketCheck {
    public Inventory inventory;
    public AbstractContainerMenu menu;
    public boolean isPacketInventoryActive = true;
    private int packetSendingInventorySize = -1;
    private static final int PLAYER_INVENTORY_CASE = -1;
    private static final int UNSUPPORTED_INVENTORY_CASE = -2;
    public boolean needResend = false;
    public int openWindowID = 0;
    public int stateID = 0;

    public CompensatedInventory(GrimPlayer playerData) {
        super(playerData);
        CorrectingPlayerInventoryStorage storage = new CorrectingPlayerInventoryStorage(this.player, 46);
        this.inventory = new Inventory(playerData, storage);
        this.menu = this.inventory;
    }

    public int getBukkitSlot(int packetSlot) {
        if (packetSlot <= 4) {
            return -1;
        }
        if (packetSlot <= 8) {
            return 7 - packetSlot + 36;
        }
        if (packetSlot <= 35) {
            return packetSlot;
        }
        if (packetSlot <= 44) {
            return packetSlot - 36;
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) && packetSlot == 45) {
            return 40;
        }
        return -1;
    }

    private void markPlayerSlotAsChanged(int clicked) {
        if (this.openWindowID == 0) {
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(clicked);
            return;
        }
        if (this.menu instanceof NotImplementedMenu) {
            return;
        }
        int nonPlayerInvSize = this.menu.getSlots().size() - 36 + 9;
        int playerInvSlotclicked = clicked - nonPlayerInvSize;
        this.inventory.getInventoryStorage().handleClientClaimedSlotSet(playerInvSlotclicked);
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getItemInHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.getHeldItem() : this.getOffHand();
    }

    private void markServerForChangingSlot(int clicked, int windowID) {
        if (this.packetSendingInventorySize == -2) {
            return;
        }
        if (this.packetSendingInventorySize == -1 || windowID == 0) {
            this.inventory.getInventoryStorage().handleServerCorrectSlot(clicked);
            return;
        }
        int nonPlayerInvSize = this.menu.getSlots().size() - 36 + 9;
        int playerInvSlotclicked = clicked - nonPlayerInvSize;
        this.inventory.getInventoryStorage().handleServerCorrectSlot(playerInvSlotclicked);
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getHeldItem() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getHeldItem() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getItemInHand());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getOffHand() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            return ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY;
        }
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getOffhand() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getItemInOffHand());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getHelmet() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getHelmet() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getHelmet());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getChestplate() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getChestplate() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getChestplate());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getLeggings() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getLeggings() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getLeggings());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    public ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getBoots() {
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack item = this.isPacketInventoryActive || this.player.bukkitPlayer == null ? this.inventory.getBoots() : SpigotConversionUtil.fromBukkitItemStack(this.player.bukkitPlayer.getInventory().getBoots());
        return item == null ? ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : item;
    }

    private ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack getByEquipmentType(EquipmentType type) {
        switch (type) {
            case HEAD: {
                return this.getHelmet();
            }
            case CHEST: {
                return this.getChestplate();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case FEET: {
                return this.getBoots();
            }
            case OFFHAND: {
                return this.getOffHand();
            }
            case MAINHAND: {
                return this.getHeldItem();
            }
        }
        return ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY;
    }

    public boolean hasItemType(ItemType type) {
        if (this.isPacketInventoryActive || this.player.bukkitPlayer == null) {
            return this.inventory.hasItemType(type);
        }
        for (ItemStack item : this.player.bukkitPlayer.getInventory().getContents()) {
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack itemStack = SpigotConversionUtil.fromBukkitItemStack(item);
            if (itemStack == null || itemStack.getType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyOfItemType(ItemType ... items) {
        if (this.isPacketInventoryActive || this.player.bukkitPlayer == null) {
            return this.inventory.hasAnyOfItemType(items);
        }
        for (ItemStack item : this.player.bukkitPlayer.getInventory().getContents()) {
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack itemStack = SpigotConversionUtil.fromBukkitItemStack(item);
            if (itemStack == null) continue;
            for (ItemType itemType : items) {
                if (itemStack.getType() != itemType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        int slot;
        WrapperPlayClientUseItem item;
        ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack use;
        EquipmentType equipmentType;
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM && (equipmentType = EquipmentType.getEquipmentSlotForItem(use = (item = new WrapperPlayClientUseItem(event)).getHand() == InteractionHand.MAIN_HAND ? this.player.getInventory().getHeldItem() : this.player.getInventory().getOffHand())) != null) {
            switch (equipmentType) {
                case HEAD: {
                    slot = 4;
                    break;
                }
                case CHEST: {
                    slot = 5;
                    break;
                }
                case LEGS: {
                    slot = 6;
                    break;
                }
                case FEET: {
                    slot = 7;
                    break;
                }
                default: {
                    return;
                }
            }
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack itemstack1 = this.getByEquipmentType(equipmentType);
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_19_4) && !itemstack1.isEmpty()) {
                return;
            }
            int swapItemSlot = item.getHand() == InteractionHand.MAIN_HAND ? this.inventory.selected + 36 : 45;
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(swapItemSlot);
            this.inventory.getInventoryStorage().setItem(swapItemSlot, itemstack1);
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(slot);
            this.inventory.getInventoryStorage().setItem(slot, use);
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            WrapperPlayClientPlayerDigging dig = new WrapperPlayClientPlayerDigging(event);
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
                return;
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM) {
                ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack heldItem = this.getHeldItem();
                if (heldItem != null) {
                    heldItem.setAmount(heldItem.getAmount() - 1);
                    if (heldItem.getAmount() <= 0) {
                        heldItem = null;
                    }
                }
                this.inventory.setHeldItem(heldItem);
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
            }
            if (dig.getAction() == DiggingAction.DROP_ITEM_STACK) {
                this.inventory.setHeldItem(null);
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.HELD_ITEM_CHANGE) {
            int slot2 = new WrapperPlayClientHeldItemChange(event).getSlot();
            if (slot2 > 8 || slot2 < 0) {
                return;
            }
            this.inventory.selected = slot2;
        }
        if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
            boolean valid;
            WrapperPlayClientCreativeInventoryAction action = new WrapperPlayClientCreativeInventoryAction(event);
            if (this.player.gamemode != GameMode.CREATIVE) {
                return;
            }
            boolean bl = action.getSlot() >= 1 && (PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_8) ? action.getSlot() <= 45 : action.getSlot() < 45) ? true : (valid = false);
            if (valid) {
                this.player.getInventory().inventory.getSlot(action.getSlot()).set(action.getItemStack());
                this.inventory.getInventoryStorage().handleClientClaimedSlotSet(action.getSlot());
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW && !event.isCancelled()) {
            WrapperPlayClientClickWindow click = new WrapperPlayClientClickWindow(event);
            if (click.getWindowId() != this.openWindowID) {
                return;
            }
            if (this.menu instanceof NotImplementedMenu) {
                return;
            }
            Optional<Map<Integer, ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack>> slots = click.getSlots();
            slots.ifPresent(integerItemStackMap -> integerItemStackMap.keySet().forEach(this::markPlayerSlotAsChanged));
            int button = click.getButton();
            slot = click.getSlot();
            WrapperPlayClientClickWindow.WindowClickType clickType = click.getWindowClickType();
            if (slot == -1 || slot == -999 || slot < this.menu.getSlots().size()) {
                this.menu.doClick(button, slot, clickType);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.CLOSE_WINDOW) {
            this.menu = this.inventory;
            this.openWindowID = 0;
            this.menu.setCarried(ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
        }
    }

    public void markSlotAsResyncing(BlockPlace place) {
        if (place.getHand() == InteractionHand.MAIN_HAND) {
            this.inventory.getInventoryStorage().handleClientClaimedSlotSet(36 + this.player.packetStateData.lastSlotSelected);
        } else {
            this.inventory.getInventoryStorage().handleServerCorrectSlot(45);
        }
    }

    public void onBlockPlace(BlockPlace place) {
        if (this.player.gamemode != GameMode.CREATIVE && place.getItemStack().getType() != ItemTypes.POWDER_SNOW_BUCKET) {
            this.markSlotAsResyncing(place);
            place.getItemStack().setAmount(place.getItemStack().getAmount() - 1);
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        PacketWrapper open;
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            open = new WrapperPlayServerOpenWindow(event);
            MenuType menuType = MenuType.getMenuType(((WrapperPlayServerOpenWindow)open).getType());
            AbstractContainerMenu newMenu = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14) ? MenuType.getMenuFromID(this.player, this.inventory, menuType) : MenuType.getMenuFromString(this.player, this.inventory, ((WrapperPlayServerOpenWindow)open).getLegacyType(), ((WrapperPlayServerOpenWindow)open).getLegacySlots(), ((WrapperPlayServerOpenWindow)open).getHorseId());
            this.packetSendingInventorySize = newMenu instanceof NotImplementedMenu ? -2 : newMenu.getSlots().size();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.lambda$onPacketSend$1((WrapperPlayServerOpenWindow)open, newMenu));
        }
        if (event.getPacketType() == PacketType.Play.Server.OPEN_HORSE_WINDOW) {
            open = new WrapperPlayServerOpenHorseWindow(event);
            this.packetSendingInventorySize = -2;
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.lambda$onPacketSend$2((WrapperPlayServerOpenHorseWindow)open));
        }
        if (event.getPacketType() == PacketType.Play.Server.CLOSE_WINDOW) {
            this.packetSendingInventorySize = -1;
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.openWindowID = 0;
                this.menu = this.inventory;
                this.menu.setCarried(ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            WrapperPlayServerWindowItems items = new WrapperPlayServerWindowItems(event);
            this.stateID = items.getStateId();
            List<ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack> slots = items.getItems();
            for (int i = 0; i < slots.size(); ++i) {
                this.markServerForChangingSlot(i, items.getWindowId());
            }
            int cachedPacketInvSize = this.packetSendingInventorySize;
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (slots.size() == cachedPacketInvSize || items.getWindowId() == 0) {
                    this.isPacketInventoryActive = true;
                }
            });
            if (items.getWindowId() == 0) {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    for (int i = 0; i < slots.size(); ++i) {
                        this.inventory.getSlot(i).set((ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack)slots.get(i));
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried(items.getCarriedItem().get());
                    }
                });
            } else {
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    if (!this.isPacketInventoryActive) {
                        return;
                    }
                    if (items.getWindowId() == this.openWindowID) {
                        for (int i = 0; i < slots.size(); ++i) {
                            this.menu.getSlot(i).set((ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack)slots.get(i));
                        }
                    }
                    if (items.getCarriedItem().isPresent()) {
                        this.inventory.setCarried(items.getCarriedItem().get());
                    }
                });
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
            WrapperPlayServerSetSlot slot = new WrapperPlayServerSetSlot(event);
            if (slot.getWindowId() == -2) {
                this.inventory.getInventoryStorage().handleServerCorrectSlot(slot.getSlot());
            } else if (slot.getWindowId() == 0) {
                this.inventory.getInventoryStorage().handleServerCorrectSlot(slot.getSlot());
            } else {
                this.markServerForChangingSlot(slot.getSlot(), slot.getWindowId());
            }
            this.stateID = slot.getStateId();
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (!this.isPacketInventoryActive) {
                    return;
                }
                if (slot.getWindowId() == -1) {
                    this.inventory.setCarried(slot.getItem());
                } else if (slot.getWindowId() == -2) {
                    if (this.inventory.getInventoryStorage().getSize() > slot.getSlot() && slot.getSlot() >= 0) {
                        this.inventory.getInventoryStorage().setItem(slot.getSlot(), slot.getItem());
                    }
                } else if (slot.getWindowId() == 0) {
                    if (slot.getSlot() >= 0 && slot.getSlot() <= 45) {
                        this.inventory.getSlot(slot.getSlot()).set(slot.getItem());
                    }
                } else if (slot.getWindowId() == this.openWindowID) {
                    this.menu.getSlot(slot.getSlot()).set(slot.getItem());
                }
            });
        }
    }

    private /* synthetic */ void lambda$onPacketSend$2(WrapperPlayServerOpenHorseWindow open) {
        this.isPacketInventoryActive = false;
        this.needResend = true;
        this.openWindowID = open.getWindowId();
    }

    private /* synthetic */ void lambda$onPacketSend$1(WrapperPlayServerOpenWindow open, AbstractContainerMenu newMenu) {
        this.openWindowID = open.getContainerId();
        this.menu = newMenu;
        this.isPacketInventoryActive = !(newMenu instanceof NotImplementedMenu);
        this.needResend = newMenu instanceof NotImplementedMenu;
    }
}

