/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.lists;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotConversionUtil;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.utils.inventory.InventoryStorage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CorrectingPlayerInventoryStorage
extends InventoryStorage {
    GrimPlayer player;
    Map<Integer, Integer> serverIsCurrentlyProcessingThesePredictions = new ConcurrentHashMap<Integer, Integer>();
    Map<Integer, Integer> pendingFinalizedSlot = new ConcurrentHashMap<Integer, Integer>();
    private static final Set<String> SUPPORTED_INVENTORIES = new HashSet<String>(Arrays.asList("CHEST", "DISPENSER", "DROPPER", "PLAYER", "ENDER_CHEST", "SHULKER_BOX", "BARREL", "CRAFTING", "CREATIVE"));

    public CorrectingPlayerInventoryStorage(GrimPlayer player, int size) {
        super(size);
        this.player = player;
    }

    public void handleClientClaimedSlotSet(int slotID) {
        if (slotID >= 0 && slotID <= 45) {
            this.pendingFinalizedSlot.put(slotID, GrimAPI.INSTANCE.getTickManager().currentTick + 5);
        }
    }

    public void handleServerCorrectSlot(int slotID) {
        if (slotID >= 0 && slotID <= 45) {
            this.serverIsCurrentlyProcessingThesePredictions.put(slotID, this.player.lastTransactionSent.get());
        }
    }

    @Override
    public void setItem(int item, ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack stack) {
        int finalTransaction = this.serverIsCurrentlyProcessingThesePredictions.getOrDefault(item, -1);
        if (finalTransaction == -1 || this.player.lastTransactionReceived.get() >= finalTransaction) {
            this.pendingFinalizedSlot.put(item, GrimAPI.INSTANCE.getTickManager().currentTick + 5);
            this.serverIsCurrentlyProcessingThesePredictions.remove(item);
        }
        super.setItem(item, stack);
    }

    private void checkThatBukkitIsSynced(int slot) {
        if (this.player.bukkitPlayer == null) {
            return;
        }
        if (!this.player.getInventory().isPacketInventoryActive) {
            return;
        }
        int bukkitSlot = this.player.getInventory().getBukkitSlot(slot);
        if (bukkitSlot != -1) {
            ItemStack bukkitItem = this.player.bukkitPlayer.getInventory().getItem(bukkitSlot);
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack existing = this.getItem(slot);
            ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack toPE = SpigotConversionUtil.fromBukkitItemStack(bukkitItem);
            if (existing.getType() != toPE.getType() || existing.getAmount() != toPE.getAmount()) {
                FoliaScheduler.getEntityScheduler().execute((Entity)this.player.bukkitPlayer, (Plugin)GrimAPI.INSTANCE.getPlugin(), () -> this.player.bukkitPlayer.updateInventory(), null, 0L);
                this.setItem(slot, toPE);
            }
        }
    }

    public void tickWithBukkit() {
        int slotToCheck;
        if (this.player.bukkitPlayer == null) {
            return;
        }
        int tickID = GrimAPI.INSTANCE.getTickManager().currentTick;
        Iterator<Map.Entry<Integer, Integer>> it = this.pendingFinalizedSlot.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            if (entry.getValue() > tickID) continue;
            this.checkThatBukkitIsSynced(entry.getKey());
            it.remove();
        }
        if (this.player.getInventory().needResend) {
            FoliaScheduler.getEntityScheduler().execute((Entity)this.player.bukkitPlayer, (Plugin)GrimAPI.INSTANCE.getPlugin(), () -> {
                if (!this.player.getInventory().needResend) {
                    return;
                }
                InventoryView view = this.player.bukkitPlayer.getOpenInventory();
                if (SUPPORTED_INVENTORIES.contains(view.getType().toString().toUpperCase(Locale.ROOT))) {
                    this.player.getInventory().needResend = false;
                    this.player.bukkitPlayer.updateInventory();
                }
            }, null, 0L);
        }
        if (tickID % 5 == 0 && !this.pendingFinalizedSlot.containsKey(slotToCheck = tickID / 5 % this.getSize()) && !this.serverIsCurrentlyProcessingThesePredictions.containsKey(slotToCheck)) {
            this.checkThatBukkitIsSynced(slotToCheck);
        }
    }
}

