/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.math;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.math.GrimMath;
import org.bukkit.util.Vector;

public class VectorUtils {
    public static Vector cutBoxToVector(Vector vectorToCutTo, Vector min, Vector max) {
        SimpleCollisionBox box = new SimpleCollisionBox(min, max).sort();
        return VectorUtils.cutBoxToVector(vectorToCutTo, box);
    }

    public static Vector cutBoxToVector(Vector vectorCutTo, SimpleCollisionBox box) {
        return new Vector(GrimMath.clamp(vectorCutTo.getX(), box.minX, box.maxX), GrimMath.clamp(vectorCutTo.getY(), box.minY, box.maxY), GrimMath.clamp(vectorCutTo.getZ(), box.minZ, box.maxZ));
    }

    public static Vector fromVec3d(Vector3d vector3d) {
        return new Vector(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public static Vector3d clampVector(Vector3d toClamp) {
        double x = GrimMath.clamp(toClamp.getX(), -3.0E7, 3.0E7);
        double y = GrimMath.clamp(toClamp.getY(), -2.0E7, 2.0E7);
        double z = GrimMath.clamp(toClamp.getZ(), -3.0E7, 3.0E7);
        return new Vector3d(x, y, z);
    }
}

