/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.impl.combat.Reach;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.change.BlockModification;
import ac.grim.grimac.utils.collisions.HitboxData;
import ac.grim.grimac.utils.collisions.RaycastData;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.ComplexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.NoCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockHitData;
import ac.grim.grimac.utils.data.EntityHitData;
import ac.grim.grimac.utils.data.HitData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.TypedPacketEntity;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.Ray;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import ac.grim.grimac.utils.nmsutil.ReachUtilsPrimitives;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.util.Vector;

public class BlockRayTrace {
    @Nullable
    public static Pair<int[], BlockFace> traverseBlocksLOSP(GrimPlayer player, double[] start, double[] end, BiFunction<WrappedBlockState, int[], Pair<int[], BlockFace>> predicate) {
        double endX = GrimMath.lerp(-1.0E-7, end[0], start[0]);
        double endY = GrimMath.lerp(-1.0E-7, end[1], start[1]);
        double endZ = GrimMath.lerp(-1.0E-7, end[2], start[2]);
        double startX = GrimMath.lerp(-1.0E-7, start[0], end[0]);
        double startY = GrimMath.lerp(-1.0E-7, start[1], end[1]);
        double startZ = GrimMath.lerp(-1.0E-7, start[2], end[2]);
        int[] floorStart = new int[]{GrimMath.floor(startX), GrimMath.floor(startY), GrimMath.floor(startZ)};
        if (start[0] == end[0] && start[1] == end[1] && start[2] == end[2]) {
            return null;
        }
        WrappedBlockState state = player.compensatedWorld.getBlock(floorStart[0], floorStart[1], floorStart[2]);
        Pair<int[], BlockFace> apply = predicate.apply(state, floorStart);
        if (apply != null) {
            return apply;
        }
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double zDiff = endZ - startZ;
        double xSign = Math.signum(xDiff);
        double ySign = Math.signum(yDiff);
        double zSign = Math.signum(zDiff);
        double posXInverse = xSign == 0.0 ? Double.MAX_VALUE : xSign / xDiff;
        double posYInverse = ySign == 0.0 ? Double.MAX_VALUE : ySign / yDiff;
        double posZInverse = zSign == 0.0 ? Double.MAX_VALUE : zSign / zDiff;
        double tMaxX = posXInverse * (xSign > 0.0 ? 1.0 - GrimMath.frac(startX) : GrimMath.frac(startX));
        double tMaxY = posYInverse * (ySign > 0.0 ? 1.0 - GrimMath.frac(startY) : GrimMath.frac(startY));
        double tMaxZ = posZInverse * (zSign > 0.0 ? 1.0 - GrimMath.frac(startZ) : GrimMath.frac(startZ));
        while (tMaxX <= 1.0 || tMaxY <= 1.0 || tMaxZ <= 1.0) {
            if (tMaxX < tMaxY) {
                if (tMaxX < tMaxZ) {
                    floorStart[0] = (int)((double)floorStart[0] + xSign);
                    tMaxX += posXInverse;
                } else {
                    floorStart[2] = (int)((double)floorStart[2] + zSign);
                    tMaxZ += posZInverse;
                }
            } else if (tMaxY < tMaxZ) {
                floorStart[1] = (int)((double)floorStart[1] + ySign);
                tMaxY += posYInverse;
            } else {
                floorStart[2] = (int)((double)floorStart[2] + zSign);
                tMaxZ += posZInverse;
            }
            if ((apply = predicate.apply(state = player.compensatedWorld.getBlock(floorStart[0], floorStart[1], floorStart[2]), floorStart)) == null) continue;
            return apply;
        }
        return null;
    }

    public static HitData traverseBlocks(GrimPlayer player, double[] start, double[] end, BiFunction<WrappedBlockState, Vector3i, HitData> predicate) {
        double endX = GrimMath.lerp(-1.0E-7, end[0], start[0]);
        double endY = GrimMath.lerp(-1.0E-7, end[1], start[1]);
        double endZ = GrimMath.lerp(-1.0E-7, end[2], start[2]);
        double startX = GrimMath.lerp(-1.0E-7, start[0], end[0]);
        double startY = GrimMath.lerp(-1.0E-7, start[1], end[1]);
        double startZ = GrimMath.lerp(-1.0E-7, start[2], end[2]);
        int floorStartX = GrimMath.floor(startX);
        int floorStartY = GrimMath.floor(startY);
        int floorStartZ = GrimMath.floor(startZ);
        if (start[0] == end[0] && start[1] == end[1] && start[2] == end[2]) {
            return null;
        }
        if (start.equals(end)) {
            return null;
        }
        WrappedBlockState state = player.compensatedWorld.getBlock(floorStartX, floorStartY, floorStartZ);
        HitData apply = predicate.apply(state, new Vector3i(floorStartX, floorStartY, floorStartZ));
        if (apply != null) {
            return apply;
        }
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double zDiff = endZ - startZ;
        double xSign = Math.signum(xDiff);
        double ySign = Math.signum(yDiff);
        double zSign = Math.signum(zDiff);
        double posXInverse = xSign == 0.0 ? Double.MAX_VALUE : xSign / xDiff;
        double posYInverse = ySign == 0.0 ? Double.MAX_VALUE : ySign / yDiff;
        double posZInverse = zSign == 0.0 ? Double.MAX_VALUE : zSign / zDiff;
        double tMaxX = posXInverse * (xSign > 0.0 ? 1.0 - GrimMath.frac(startX) : GrimMath.frac(startX));
        double tMaxY = posYInverse * (ySign > 0.0 ? 1.0 - GrimMath.frac(startY) : GrimMath.frac(startY));
        double tMaxZ = posZInverse * (zSign > 0.0 ? 1.0 - GrimMath.frac(startZ) : GrimMath.frac(startZ));
        while (tMaxX <= 1.0 || tMaxY <= 1.0 || tMaxZ <= 1.0) {
            if (tMaxX < tMaxY) {
                if (tMaxX < tMaxZ) {
                    floorStartX = (int)((double)floorStartX + xSign);
                    tMaxX += posXInverse;
                } else {
                    floorStartZ = (int)((double)floorStartZ + zSign);
                    tMaxZ += posZInverse;
                }
            } else if (tMaxY < tMaxZ) {
                floorStartY = (int)((double)floorStartY + ySign);
                tMaxY += posYInverse;
            } else {
                floorStartZ = (int)((double)floorStartZ + zSign);
                tMaxZ += posZInverse;
            }
            if ((apply = predicate.apply(state = player.compensatedWorld.getBlock(floorStartX, floorStartY, floorStartZ), new Vector3i(floorStartX, floorStartY, floorStartZ))) == null) continue;
            return apply;
        }
        return null;
    }

    public static HitData traverseBlocks(GrimPlayer player, Vector3d start, Vector3d end, BiFunction<WrappedBlockState, Vector3i, HitData> predicate) {
        return BlockRayTrace.traverseBlocks(player, new double[]{start.x, start.y, start.z}, new double[]{end.x, end.y, end.z}, predicate);
    }

    @Nullable
    public static BlockHitData getNearestHitResult(GrimPlayer player, double[] startPos, double[] lookVec, double currentDistance, double maxDistance, int[] targetBlockVec, BlockFace expectedBlockFace, SimpleCollisionBox[] boxes, boolean raycastContext) {
        double[] endPos = new double[]{startPos[0] + lookVec[0] * maxDistance, startPos[1] + lookVec[1] * maxDistance, startPos[2] + lookVec[2] * maxDistance};
        return (BlockHitData)BlockRayTrace.traverseBlocks(player, startPos, endPos, (WrappedBlockState block, Vector3i vector3i) -> {
            int currentTick = GrimAPI.INSTANCE.getTickManager().currentTick;
            List<WrappedBlockState> blockModifications = player.blockHistory.getBlockStates(blockModification -> blockModification.location().equals(vector3i) && currentTick - blockModification.tick() < 2 && (blockModification.cause() == BlockModification.Cause.START_DIGGING || blockModification.cause() == BlockModification.Cause.HANDLE_NETTY_SYNC_TRANSACTION));
            blockModifications.add(0, (WrappedBlockState)block);
            BlockHitData hitData = null;
            boolean isTargetBlock = Arrays.equals(new int[]{vector3i.x, vector3i.y, vector3i.z}, targetBlockVec);
            for (WrappedBlockState wrappedBlockState : blockModifications) {
                hitData = BlockRayTrace.didHitBlock(player, startPos, lookVec, currentDistance, maxDistance, targetBlockVec, expectedBlockFace, boxes, raycastContext, wrappedBlockState, vector3i);
                if (!(isTargetBlock ? hitData != null && hitData.success != false : hitData == null)) continue;
                return hitData;
            }
            return hitData;
        });
    }

    public static BlockHitData didHitBlock(GrimPlayer player, double[] startPos, double[] lookVec, double currentDistance, double maxDistance, int[] targetBlockVec, BlockFace expectedBlockFace, SimpleCollisionBox[] boxes, boolean raycastContext, WrappedBlockState block, Vector3i vector3i) {
        boolean isTargetBlock = Arrays.equals(new int[]{vector3i.x, vector3i.y, vector3i.z}, targetBlockVec);
        CollisionBox data = !raycastContext ? HitboxData.getBlockHitbox(player, player.getInventory().getHeldItem().getType().getPlacedType(), player.getClientVersion(), block, isTargetBlock, vector3i.x, vector3i.y, vector3i.z) : RaycastData.getBlockHitbox(player, null, player.getClientVersion(), block, vector3i.x, vector3i.y, vector3i.z);
        if (data == NoCollisionBox.INSTANCE) {
            return null;
        }
        int size = data.downCast(boxes);
        double bestHitResult = Double.MAX_VALUE;
        double[] bestHitLoc = null;
        BlockFace bestFace = null;
        double[] currentEnd = new double[]{startPos[0] + lookVec[0] * currentDistance, startPos[1] + lookVec[1] * currentDistance, startPos[2] + lookVec[2] * currentDistance};
        for (int i = 0; i < size; ++i) {
            double[] hitLoc;
            double distSq;
            Pair<double[], BlockFace> intercept = ReachUtilsPrimitives.calculateIntercept(boxes[i], startPos, currentEnd);
            if (intercept.first() == null || !((distSq = BlockRayTrace.distanceSquared(hitLoc = intercept.first(), startPos)) < bestHitResult)) continue;
            bestHitResult = distSq;
            bestHitLoc = hitLoc;
            bestFace = intercept.second();
            if (!isTargetBlock || bestFace != expectedBlockFace) continue;
            return new BlockHitData(vector3i, new Vector(bestHitLoc[0], bestHitLoc[1], bestHitLoc[2]), bestFace, block, true);
        }
        if (bestHitLoc != null) {
            BlockHitData hitData2;
            BlockHitData hitData = new BlockHitData(vector3i, new Vector((double)bestHitLoc[0], (double)bestHitLoc[1], (double)bestHitLoc[2]), bestFace, block, isTargetBlock);
            if (!raycastContext && (hitData2 = BlockRayTrace.didHitBlock(player, startPos, lookVec, maxDistance, maxDistance, targetBlockVec, expectedBlockFace, boxes, true, block, vector3i)) != null) {
                Vector startVector = new Vector(startPos[0], startPos[1], startPos[2]);
                if (hitData2.getBlockHitLocation().subtract(startVector).lengthSquared() < hitData.getBlockHitLocation().subtract(startVector).lengthSquared()) {
                    return new BlockHitData(vector3i, hitData.getBlockHitLocation(), hitData2.getClosestDirection(), block, isTargetBlock);
                }
            }
            return hitData;
        }
        return null;
    }

    private static double distanceSquared(double[] vec1, double[] vec2) {
        double dx = vec1[0] - vec2[0];
        double dy = vec1[1] - vec2[1];
        double dz = vec1[2] - vec2[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public static HitData getNearestHitResult(GrimPlayer player, StateType heldItem, boolean sourcesHaveHitbox) {
        Vector3d startingPos = new Vector3d(player.x, player.y + player.getEyeHeight(), player.z);
        Vector startingVec = new Vector(startingPos.getX(), startingPos.getY(), startingPos.getZ());
        Ray trace = new Ray(player, startingPos.getX(), startingPos.getY(), startingPos.getZ(), player.xRot, player.yRot);
        double distance = player.compensatedEntities.self.getAttributeValue(Attributes.PLAYER_BLOCK_INTERACTION_RANGE);
        Vector endVec = trace.getPointAtDistance(distance);
        Vector3d endPos = new Vector3d(endVec.getX(), endVec.getY(), endVec.getZ());
        return BlockRayTrace.getTraverseResult(player, heldItem, startingPos, startingVec, trace, endPos, sourcesHaveHitbox, false, distance + 3.0, false);
    }

    @Nullable
    public static HitData getNearestHitResult(GrimPlayer player, PacketEntity targetEntity, Vector eyePos, Vector lookVec) {
        double maxAttackDistance = player.compensatedEntities.self.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        double maxBlockDistance = player.compensatedEntities.self.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vector3d startingPos = new Vector3d(eyePos.getX(), eyePos.getY(), eyePos.getZ());
        Vector startingVec = new Vector(startingPos.getX(), startingPos.getY(), startingPos.getZ());
        Ray trace = new Ray(eyePos, lookVec);
        Vector endVec = trace.getPointAtDistance(maxBlockDistance);
        Vector3d endPos = new Vector3d(endVec.getX(), endVec.getY(), endVec.getZ());
        HitData blockHitData = BlockRayTrace.getTraverseResult(player, null, startingPos, startingVec, trace, endPos, false, true, maxBlockDistance, true);
        Vector closestHitVec = null;
        PacketEntity closestEntity = null;
        double closestDistanceSquared = blockHitData != null ? blockHitData.getBlockHitLocation().distanceSquared(startingVec) : maxAttackDistance * maxAttackDistance;
        for (PacketEntity entity : player.compensatedEntities.entityMap.values().stream().filter(TypedPacketEntity::canHit).collect(Collectors.toList())) {
            double distSquared;
            Pair<Vector, BlockFace> intercept;
            SimpleCollisionBox box = null;
            if (entity.equals(targetEntity)) {
                box = entity.getPossibleCollisionBoxes();
                box.expand(player.checkManager.getPacketCheck(Reach.class).reachThreshold);
                if (!player.packetStateData.didLastLastMovementIncludePosition || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                    box.expand(player.getMovementThreshold());
                }
                if (ReachUtils.isVecInside(box, eyePos)) {
                    return new EntityHitData(entity, eyePos);
                }
            } else {
                CollisionBox b = entity.getMinimumPossibleCollisionBoxes();
                if (b instanceof NoCollisionBox) continue;
                box = (SimpleCollisionBox)b;
                box.expand(-player.checkManager.getPacketCheck(Reach.class).reachThreshold);
                if (!player.packetStateData.didLastLastMovementIncludePosition || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                    box.expand(-player.getMovementThreshold());
                }
            }
            if (player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
                box.expand(0.1f);
            }
            if ((intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(Math.sqrt(closestDistanceSquared)))).first() == null || !((distSquared = intercept.first().distanceSquared(startingVec)) < closestDistanceSquared)) continue;
            closestDistanceSquared = distSquared;
            closestHitVec = intercept.first();
            closestEntity = entity;
        }
        return closestEntity == null ? blockHitData : new EntityHitData(closestEntity, closestHitVec);
    }

    private static HitData getTraverseResult(GrimPlayer player, @Nullable StateType heldItem, Vector3d startingPos, Vector startingVec, Ray trace, Vector3d endPos, boolean sourcesHaveHitbox, boolean checkInside, double knownDistance, boolean shrinkBlocks) {
        return BlockRayTrace.traverseBlocks(player, startingPos, endPos, (WrappedBlockState block, Vector3i vector3i) -> {
            CollisionBox data = HitboxData.getBlockHitbox(player, heldItem, player.getClientVersion(), block, false, vector3i.getX(), vector3i.getY(), vector3i.getZ());
            SimpleCollisionBox[] boxes = new SimpleCollisionBox[ComplexCollisionBox.DEFAULT_MAX_COLLISION_BOX_SIZE];
            int size = data.downCast(boxes);
            double bestHitResult = Double.MAX_VALUE;
            Vector bestHitLoc = null;
            BlockFace bestFace = null;
            for (int i = 0; i < size; ++i) {
                Pair<Vector, BlockFace> intercept;
                if (shrinkBlocks) {
                    boxes[i].expand(-player.getMovementThreshold());
                }
                if ((intercept = ReachUtils.calculateIntercept(boxes[i], trace.getOrigin(), trace.getPointAtDistance(knownDistance))).first() == null) continue;
                Vector hitLoc = intercept.first();
                if (checkInside && ReachUtils.isVecInside(boxes[i], trace.getOrigin())) {
                    return null;
                }
                if (!(hitLoc.distanceSquared(startingVec) < bestHitResult)) continue;
                bestHitResult = hitLoc.distanceSquared(startingVec);
                bestHitLoc = hitLoc;
                bestFace = intercept.second();
            }
            if (bestHitLoc != null) {
                return new BlockHitData((Vector3i)vector3i, bestHitLoc, bestFace, (WrappedBlockState)block, null);
            }
            if (sourcesHaveHitbox && (player.compensatedWorld.isWaterSourceBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ()) || player.compensatedWorld.getLavaFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ()) == 0.8888888955116272)) {
                double waterHeight = player.compensatedWorld.getFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ());
                SimpleCollisionBox box = new SimpleCollisionBox(vector3i.getX(), vector3i.getY(), vector3i.getZ(), vector3i.getX() + 1, (double)vector3i.getY() + waterHeight, vector3i.getZ() + 1);
                Pair<Vector, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(knownDistance));
                if (intercept.first() != null) {
                    return new BlockHitData((Vector3i)vector3i, intercept.first(), intercept.second(), (WrappedBlockState)block, null);
                }
            }
            return null;
        });
    }
}

