/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class BukkitNMS {
    @NotNull
    private static final ItemUsageReset resetItemUsage = BukkitNMS.createItemUsageResetFunction();

    public static void resetItemUsage(@Nullable Player player) {
        if (player != null) {
            resetItemUsage.accept(player);
        }
    }

    @NotNull
    private static ItemUsageReset createItemUsageResetFunction() {
        String clearActiveItemMethodName;
        String nmsPackage;
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            if (version.isOlderThan(ServerVersion.V_1_19)) {
                Method clearActiveItem = LivingEntity.class.getMethod("clearActiveItem", new Class[0]);
                return x$0 -> clearActiveItem.invoke(x$0, new Object[0]);
            }
            Method setLivingEntityFlag = Class.forName(version.isOlderThan(ServerVersion.V_1_20_5) ? "net.minecraft.world.entity.EntityLiving" : "net.minecraft.world.entity.LivingEntity").getDeclaredMethod(version.isOlderThan(ServerVersion.V_1_20_5) ? "c" : "setLivingEntityFlag", Integer.TYPE, Boolean.TYPE);
            Method getHandle = (version.isOlderThan(ServerVersion.V_1_20_5) ? Class.forName("org.bukkit.craftbukkit." + BukkitNMS.getNmsPackageName() + ".entity.CraftPlayer") : Class.forName("org.bukkit.craftbukkit.entity.CraftPlayer")).getMethod("getHandle", new Class[0]);
            setLivingEntityFlag.setAccessible(true);
            Method clearActiveItem = Player.class.getMethod("clearActiveItem", new Class[0]);
            return player -> {
                setLivingEntityFlag.invoke(getHandle.invoke((Object)player, new Object[0]), 1, false);
                clearActiveItem.invoke((Object)player, new Object[0]);
            };
        }
        if (version == ServerVersion.V_1_8_8) {
            Class<?> EntityHuman = Class.forName("net.minecraft.server.v1_8_R3.EntityHuman");
            Method getHandle = Class.forName("org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer").getMethod("getHandle", new Class[0]);
            Method clearActiveItem = EntityHuman.getMethod("bV", new Class[0]);
            Method isUsingItem = EntityHuman.getMethod("bS", new Class[0]);
            return player -> {
                Object handle = getHandle.invoke((Object)player, new Object[0]);
                clearActiveItem.invoke(handle, new Object[0]);
                if (((Boolean)isUsingItem.invoke(handle, new Object[0])).booleanValue()) {
                    player.updateInventory();
                }
            };
        }
        switch (nmsPackage = BukkitNMS.getNmsPackageName()) {
            case "v1_9_R1": {
                clearActiveItemMethodName = "cz";
                break;
            }
            case "v1_9_R2": {
                clearActiveItemMethodName = "cA";
                break;
            }
            case "v1_10_R1": {
                clearActiveItemMethodName = "cE";
                break;
            }
            case "v1_11_R1": {
                clearActiveItemMethodName = "cF";
                break;
            }
            case "v1_12_R1": {
                clearActiveItemMethodName = "cN";
                break;
            }
            case "v1_13_R1": 
            case "v1_13_R2": {
                clearActiveItemMethodName = "da";
                break;
            }
            case "v1_14_R1": {
                clearActiveItemMethodName = "dp";
                break;
            }
            case "v1_15_R1": {
                clearActiveItemMethodName = "dH";
                break;
            }
            case "v1_16_R1": 
            case "v1_16_R2": 
            case "v1_16_R3": {
                clearActiveItemMethodName = "clearActiveItem";
                break;
            }
            default: {
                throw new IllegalStateException("You are using an unsupported server version! (" + version.getReleaseName() + ")");
            }
        }
        Method getHandle = Class.forName("org.bukkit.craftbukkit." + nmsPackage + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
        Method clearActiveItem = Class.forName("net.minecraft.server." + nmsPackage + ".EntityLiving").getMethod(clearActiveItemMethodName, new Class[0]);
        return player -> clearActiveItem.invoke(getHandle.invoke((Object)player, new Object[0]), new Object[0]);
    }

    private static String getNmsPackageName() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    private BukkitNMS() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface ItemUsageReset {
        public void accept(@NotNull Player var1) throws Throwable;
    }
}

