/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReachUtilsPrimitives {
    public static @NotNull Pair<@Nullable double[], @Nullable BlockFace> calculateIntercept(SimpleCollisionBox self, double[] origin, double[] end) {
        double distSq;
        double[] minX = ReachUtilsPrimitives.getIntermediateWithXValue(origin, end, self.minX);
        double[] maxX = ReachUtilsPrimitives.getIntermediateWithXValue(origin, end, self.maxX);
        double[] minY = ReachUtilsPrimitives.getIntermediateWithYValue(origin, end, self.minY);
        double[] maxY = ReachUtilsPrimitives.getIntermediateWithYValue(origin, end, self.maxY);
        double[] minZ = ReachUtilsPrimitives.getIntermediateWithZValue(origin, end, self.minZ);
        double[] maxZ = ReachUtilsPrimitives.getIntermediateWithZValue(origin, end, self.maxZ);
        BlockFace bestFace = null;
        if (!ReachUtilsPrimitives.isVecInYZ(self, minX)) {
            minX = null;
        }
        if (!ReachUtilsPrimitives.isVecInYZ(self, maxX)) {
            maxX = null;
        }
        if (!ReachUtilsPrimitives.isVecInXZ(self, minY)) {
            minY = null;
        }
        if (!ReachUtilsPrimitives.isVecInXZ(self, maxY)) {
            maxY = null;
        }
        if (!ReachUtilsPrimitives.isVecInXY(self, minZ)) {
            minZ = null;
        }
        if (!ReachUtilsPrimitives.isVecInXY(self, maxZ)) {
            maxZ = null;
        }
        double[] best = null;
        double bestDistSq = Double.MAX_VALUE;
        if (minX != null) {
            best = minX;
            bestDistSq = ReachUtilsPrimitives.distanceSquared(origin, minX);
            bestFace = BlockFace.WEST;
        }
        if (maxX != null) {
            distSq = ReachUtilsPrimitives.distanceSquared(origin, maxX);
            if (best == null || distSq < bestDistSq) {
                best = maxX;
                bestDistSq = distSq;
                bestFace = BlockFace.EAST;
            }
        }
        if (minY != null) {
            distSq = ReachUtilsPrimitives.distanceSquared(origin, minY);
            if (best == null || distSq < bestDistSq) {
                best = minY;
                bestDistSq = distSq;
                bestFace = BlockFace.DOWN;
            }
        }
        if (maxY != null) {
            distSq = ReachUtilsPrimitives.distanceSquared(origin, maxY);
            if (best == null || distSq < bestDistSq) {
                best = maxY;
                bestDistSq = distSq;
                bestFace = BlockFace.UP;
            }
        }
        if (minZ != null) {
            distSq = ReachUtilsPrimitives.distanceSquared(origin, minZ);
            if (best == null || distSq < bestDistSq) {
                best = minZ;
                bestDistSq = distSq;
                bestFace = BlockFace.NORTH;
            }
        }
        if (maxZ != null) {
            distSq = ReachUtilsPrimitives.distanceSquared(origin, maxZ);
            if (best == null || distSq < bestDistSq) {
                best = maxZ;
                bestFace = BlockFace.SOUTH;
            }
        }
        return new Pair<double[], BlockFace>(best, bestFace);
    }

    private static double[] getIntermediateWithXValue(double[] self, double[] other, double x) {
        double[] dArray;
        double d0 = other[0] - self[0];
        double d1 = other[1] - self[1];
        double d2 = other[2] - self[2];
        if (d0 * d0 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (x - self[0]) / d0;
        if (d3 >= 0.0 && d3 <= 1.0) {
            double[] dArray2 = new double[3];
            dArray2[0] = self[0] + d0 * d3;
            dArray2[1] = self[1] + d1 * d3;
            dArray = dArray2;
            dArray2[2] = self[2] + d2 * d3;
        } else {
            dArray = null;
        }
        return dArray;
    }

    private static double[] getIntermediateWithYValue(double[] self, double[] other, double y) {
        double[] dArray;
        double d0 = other[0] - self[0];
        double d1 = other[1] - self[1];
        double d2 = other[2] - self[2];
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (y - self[1]) / d1;
        if (d3 >= 0.0 && d3 <= 1.0) {
            double[] dArray2 = new double[3];
            dArray2[0] = self[0] + d0 * d3;
            dArray2[1] = self[1] + d1 * d3;
            dArray = dArray2;
            dArray2[2] = self[2] + d2 * d3;
        } else {
            dArray = null;
        }
        return dArray;
    }

    private static double[] getIntermediateWithZValue(double[] self, double[] other, double z) {
        double[] dArray;
        double d0 = other[0] - self[0];
        double d1 = other[1] - self[1];
        double d2 = other[2] - self[2];
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (z - self[2]) / d2;
        if (d3 >= 0.0 && d3 <= 1.0) {
            double[] dArray2 = new double[3];
            dArray2[0] = self[0] + d0 * d3;
            dArray2[1] = self[1] + d1 * d3;
            dArray = dArray2;
            dArray2[2] = self[2] + d2 * d3;
        } else {
            dArray = null;
        }
        return dArray;
    }

    private static boolean isVecInYZ(SimpleCollisionBox self, double[] vec) {
        return vec != null && vec[1] >= self.minY && vec[1] <= self.maxY && vec[2] >= self.minZ && vec[2] <= self.maxZ;
    }

    private static boolean isVecInXZ(SimpleCollisionBox self, double[] vec) {
        return vec != null && vec[0] >= self.minX && vec[0] <= self.maxX && vec[2] >= self.minZ && vec[2] <= self.maxZ;
    }

    private static boolean isVecInXY(SimpleCollisionBox self, double[] vec) {
        return vec != null && vec[0] >= self.minX && vec[0] <= self.maxX && vec[1] >= self.minY && vec[1] <= self.maxY;
    }

    public static boolean isVecInside(SimpleCollisionBox self, double[] vec) {
        return vec[0] > self.minX && vec[0] < self.maxX && vec[1] > self.minY && vec[1] < self.maxY && vec[2] > self.minZ && vec[2] < self.maxZ;
    }

    private static double distanceSquared(double[] vec1, double[] vec2) {
        double dx = vec1[0] - vec2[0];
        double dy = vec1[1] - vec2[1];
        double dz = vec1[2] - vec2[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public static double[] getLook(GrimPlayer player, float yaw, float pitch) {
        double[] result = new double[3];
        ReachUtilsPrimitives.getLook(player, yaw, pitch, result);
        return result;
    }

    public static void getLook(GrimPlayer player, float yaw, float pitch, double[] result) {
        if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            float f = player.trigHandler.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f1 = player.trigHandler.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f2 = -player.trigHandler.cos(-pitch * ((float)Math.PI / 180));
            float f3 = player.trigHandler.sin(-pitch * ((float)Math.PI / 180));
            result[0] = f1 * f2;
            result[1] = f3;
            result[2] = f * f2;
        } else {
            float f = pitch * ((float)Math.PI / 180);
            float f1 = -yaw * ((float)Math.PI / 180);
            float f2 = player.trigHandler.cos(f1);
            float f3 = player.trigHandler.sin(f1);
            float f4 = player.trigHandler.cos(f);
            float f5 = player.trigHandler.sin(f);
            result[0] = f3 * f4;
            result[1] = -f5;
            result[2] = f2 * f4;
        }
    }
}

