/*
 * Decompiled with CFR 0.152.
 */
package com.whiteboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class WhiteboardData {
    private String name;
    private long timestamp;
    private List<DrawingStroke> strokes;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"whiteboard");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public WhiteboardData(String name) {
        this.name = name;
        this.timestamp = System.currentTimeMillis();
        this.strokes = new ArrayList<DrawingStroke>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<DrawingStroke> getStrokes() {
        return this.strokes;
    }

    public void addStroke(DrawingStroke stroke) {
        this.strokes.add(stroke);
    }

    public void clear() {
        this.strokes.clear();
    }

    public static Path getWhiteboardDirectory() {
        Path gameDir = class_310.method_1551().field_1697.toPath();
        Path whiteboardDir = gameDir.resolve("whiteboards");
        try {
            Files.createDirectories(whiteboardDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create whiteboard directory", (Throwable)e);
        }
        return whiteboardDir;
    }

    public void save() {
        Path dir = WhiteboardData.getWhiteboardDirectory();
        String fileName = this.name.replaceAll("[^a-zA-Z0-9-_]", "_") + ".json";
        Path file = dir.resolve(fileName);
        try (FileWriter writer = new FileWriter(file.toFile());){
            GSON.toJson((Object)this, (Appendable)writer);
            LOGGER.info("Saved whiteboard: " + this.name);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save whiteboard: " + this.name, (Throwable)e);
        }
    }

    public static WhiteboardData load(String fileName) {
        WhiteboardData whiteboardData;
        Path dir = WhiteboardData.getWhiteboardDirectory();
        Path file = dir.resolve(fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        FileReader reader = new FileReader(file.toFile());
        try {
            WhiteboardData data = (WhiteboardData)GSON.fromJson((Reader)reader, WhiteboardData.class);
            LOGGER.info("Loaded whiteboard: " + data.name);
            whiteboardData = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load whiteboard: " + fileName, (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return whiteboardData;
    }

    public static List<WhiteboardData> loadAll() {
        ArrayList<WhiteboardData> whiteboards = new ArrayList<WhiteboardData>();
        Path dir = WhiteboardData.getWhiteboardDirectory();
        try {
            Files.list(dir).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                WhiteboardData data = WhiteboardData.load(path.getFileName().toString());
                if (data != null) {
                    whiteboards.add(data);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to load whiteboards", (Throwable)e);
        }
        whiteboards.sort((a, b) -> Long.compare(b.timestamp, a.timestamp));
        return whiteboards;
    }

    public void delete() {
        Path dir = WhiteboardData.getWhiteboardDirectory();
        String fileName = this.name.replaceAll("[^a-zA-Z0-9-_]", "_") + ".json";
        Path file = dir.resolve(fileName);
        try {
            Files.deleteIfExists(file);
            LOGGER.info("Deleted whiteboard: " + this.name);
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete whiteboard: " + this.name, (Throwable)e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DrawingStroke {
        private List<Point> points = new ArrayList<Point>();
        private int color;
        private int size;

        public DrawingStroke(int color, int size) {
            this.color = color;
            this.size = size;
        }

        public void addPoint(int x, int y) {
            this.points.add(new Point(x, y));
        }

        public List<Point> getPoints() {
            return this.points;
        }

        public int getColor() {
            return this.color;
        }

        public int getSize() {
            return this.size;
        }

        @Environment(value=EnvType.CLIENT)
        public static class Point {
            private int x;
            private int y;

            public Point(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }
        }
    }
}

