/*
 * Decompiled with CFR 0.152.
 */
package com.whiteboard;

import com.whiteboard.DrawingTool;
import com.whiteboard.WhiteboardData;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class WhiteboardScreen
extends class_437 {
    private WhiteboardData currentWhiteboard;
    private DrawingTool currentTool = DrawingTool.PEN;
    private WhiteboardData.DrawingStroke currentStroke = null;
    private boolean isDrawing = false;
    private int fillColor = -16777216;
    private int[][] canvasPixels = null;
    private boolean needsRedraw = true;
    private int canvasX;
    private int canvasY;
    private int canvasWidth;
    private int canvasHeight;
    private int toolPanelX;
    private int toolPanelY;
    private int toolPanelWidth = 60;
    private int toolButtonSize = 50;
    private int toolScrollOffset = 0;
    private int maxToolScroll = 0;
    private int topBarHeight = 40;
    private List<WhiteboardData> savedWhiteboards;
    private boolean showWhiteboardSelector = false;
    private int selectorScrollOffset = 0;

    public WhiteboardScreen() {
        super((class_2561)class_2561.method_43470((String)"Whiteboard"));
        this.loadSavedWhiteboards();
        this.currentWhiteboard = !this.savedWhiteboards.isEmpty() ? this.savedWhiteboards.get(0) : new WhiteboardData("Whiteboard 1");
    }

    private void loadSavedWhiteboards() {
        this.savedWhiteboards = WhiteboardData.loadAll();
    }

    protected void method_25426() {
        super.method_25426();
        this.canvasX = this.toolPanelWidth + 20;
        this.canvasY = this.topBarHeight + 10;
        this.canvasWidth = this.field_22789 - this.canvasX - 10;
        this.canvasHeight = this.field_22790 - this.canvasY - 10;
        this.toolPanelX = 10;
        this.toolPanelY = this.topBarHeight + 10;
        this.canvasPixels = new int[this.canvasWidth][this.canvasHeight];
        for (int x = 0; x < this.canvasWidth; ++x) {
            for (int y = 0; y < this.canvasHeight; ++y) {
                this.canvasPixels[x][y] = -1;
            }
        }
        this.needsRedraw = true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.field_22789, this.field_22790, -535818224);
        this.renderTopBar(context, mouseX, mouseY);
        context.method_25294(this.canvasX - 1, this.canvasY - 1, this.canvasX + this.canvasWidth + 1, this.canvasY + this.canvasHeight + 1, -16777216);
        context.method_25294(this.canvasX, this.canvasY, this.canvasX + this.canvasWidth, this.canvasY + this.canvasHeight, -1);
        this.renderStrokes(context);
        this.renderToolPanel(context, mouseX, mouseY);
        if (this.showWhiteboardSelector) {
            this.renderWhiteboardSelector(context, mouseX, mouseY);
        }
    }

    private void renderTopBar(class_332 context, int mouseX, int mouseY) {
        context.method_25294(0, 0, this.field_22789, this.topBarHeight, -1073741824);
        int nameWidth = this.field_22793.method_1727(this.currentWhiteboard.getName()) + 20;
        boolean hoveringName = mouseX >= 10 && mouseX <= 10 + nameWidth && mouseY >= 10 && mouseY <= 30;
        int nameColor = hoveringName ? 0x40FFFFFF : 0x20FFFFFF;
        context.method_25294(10, 10, 10 + nameWidth, 30, nameColor);
        context.method_51433(this.field_22793, this.currentWhiteboard.getName(), 15, 15, -1, false);
        context.method_51433(this.field_22793, "v", 10 + nameWidth - 12, 15, -1, false);
        int newButtonX = this.field_22789 - 120;
        int newButtonY = 10;
        int newButtonSize = 20;
        boolean hoveringNew = mouseX >= newButtonX && mouseX <= newButtonX + newButtonSize && mouseY >= newButtonY && mouseY <= newButtonY + newButtonSize;
        int newButtonColor = hoveringNew ? -520093697 : -1593835521;
        context.method_25294(newButtonX, newButtonY, newButtonX + newButtonSize, newButtonY + newButtonSize, newButtonColor);
        context.method_25294(newButtonX + 9, newButtonY + 4, newButtonX + 11, newButtonY + 16, -16777216);
        context.method_25294(newButtonX + 4, newButtonY + 9, newButtonX + 16, newButtonY + 11, -16777216);
        int saveButtonX = this.field_22789 - 90;
        int saveButtonY = 10;
        int saveButtonWidth = 60;
        int saveButtonHeight = 20;
        boolean hoveringSave = mouseX >= saveButtonX && mouseX <= saveButtonX + saveButtonWidth && mouseY >= saveButtonY && mouseY <= saveButtonY + saveButtonHeight;
        int saveButtonColor = hoveringSave ? -520093697 : -1593835521;
        context.method_25294(saveButtonX, saveButtonY, saveButtonX + saveButtonWidth, saveButtonY + saveButtonHeight, saveButtonColor);
        context.method_51433(this.field_22793, "Save", saveButtonX + 18, saveButtonY + 6, -16777216, false);
        int clearButtonX = this.field_22789 - 220;
        int clearButtonY = 10;
        int clearButtonWidth = 60;
        int clearButtonHeight = 20;
        boolean hoveringClear = mouseX >= clearButtonX && mouseX <= clearButtonX + clearButtonWidth && mouseY >= clearButtonY && mouseY <= clearButtonY + clearButtonHeight;
        int clearButtonColor = hoveringClear ? -520133018 : -1593874842;
        context.method_25294(clearButtonX, clearButtonY, clearButtonX + clearButtonWidth, clearButtonY + clearButtonHeight, clearButtonColor);
        context.method_51433(this.field_22793, "Clear", clearButtonX + 14, clearButtonY + 6, -16777216, false);
    }

    private void renderToolPanel(class_332 context, int mouseX, int mouseY) {
        DrawingTool[] tools = DrawingTool.values();
        int availableHeight = this.field_22790 - this.toolPanelY - 10;
        int totalToolHeight = tools.length * (this.toolButtonSize + 5);
        this.maxToolScroll = Math.max(0, totalToolHeight - availableHeight);
        this.toolScrollOffset = Math.max(0, Math.min(this.toolScrollOffset, this.maxToolScroll));
        context.method_44379(this.toolPanelX, this.toolPanelY, this.toolPanelX + this.toolPanelWidth, this.toolPanelY + availableHeight);
        for (int i = 0; i < tools.length; ++i) {
            boolean selected;
            DrawingTool tool = tools[i];
            int buttonY = this.toolPanelY + i * (this.toolButtonSize + 5) - this.toolScrollOffset;
            if (buttonY + this.toolButtonSize < this.toolPanelY || buttonY > this.toolPanelY + availableHeight) continue;
            boolean hovering = mouseX >= this.toolPanelX && mouseX <= this.toolPanelX + this.toolButtonSize && mouseY >= buttonY && mouseY <= buttonY + this.toolButtonSize && mouseY >= this.toolPanelY && mouseY <= this.toolPanelY + availableHeight;
            boolean bl = selected = tool == this.currentTool;
            int bgColor = selected ? -520093697 : (hovering ? -1060320052 : -1601664888);
            context.method_25294(this.toolPanelX, buttonY, this.toolPanelX + this.toolButtonSize, buttonY + this.toolButtonSize, bgColor);
            if (tool.isFillTool()) {
                int iconSize = 20;
                int iconX = this.toolPanelX + this.toolButtonSize / 2 - iconSize / 2;
                int iconY = buttonY + this.toolButtonSize / 2 - iconSize / 2;
                context.method_25294(iconX + 5, iconY, iconX + 15, iconY + 15, this.fillColor);
                context.method_25294(iconX, iconY + 12, iconX + 20, iconY + 18, -1610612736);
            } else {
                int previewSize = Math.max(tool.getSize() * 3, 6);
                int previewX = this.toolPanelX + this.toolButtonSize / 2 - previewSize / 2;
                int previewY = buttonY + this.toolButtonSize / 2 - previewSize / 2;
                context.method_25294(previewX, previewY, previewX + previewSize, previewY + previewSize, tool.getColor());
            }
            String toolName = tool.getName();
            if (tool.isFillTool()) {
                toolName = "Fill";
            }
            int textWidth = this.field_22793.method_1727(toolName);
            int textX = this.toolPanelX + this.toolButtonSize / 2 - textWidth / 2;
            int textY = buttonY + this.toolButtonSize - 12;
            context.method_51433(this.field_22793, toolName, textX, textY, -16777216, false);
        }
        context.method_44380();
        if (this.maxToolScroll > 0) {
            if (this.toolScrollOffset > 0) {
                context.method_51433(this.field_22793, "^", this.toolPanelX + 25, this.toolPanelY + 2, -1, false);
            }
            if (this.toolScrollOffset < this.maxToolScroll) {
                context.method_51433(this.field_22793, "v", this.toolPanelX + 25, this.toolPanelY + availableHeight - 10, -1, false);
            }
        }
    }

    private void renderWhiteboardSelector(class_332 context, int mouseX, int mouseY) {
        int selectorWidth = 200;
        int maxSelectorHeight = 300;
        int selectorX = 10;
        int selectorY = this.topBarHeight + 5;
        int totalContentHeight = this.savedWhiteboards.size() * 25 + 10;
        int selectorHeight = Math.min(maxSelectorHeight, totalContentHeight);
        int maxScroll = Math.max(0, totalContentHeight - selectorHeight);
        this.selectorScrollOffset = Math.max(0, Math.min(this.selectorScrollOffset, maxScroll));
        context.method_25294(selectorX, selectorY, selectorX + selectorWidth, selectorY + selectorHeight, -536870912);
        context.method_25294(selectorX - 1, selectorY - 1, selectorX + selectorWidth + 1, selectorY, -1);
        context.method_25294(selectorX - 1, selectorY + selectorHeight, selectorX + selectorWidth + 1, selectorY + selectorHeight + 1, -1);
        context.method_25294(selectorX - 1, selectorY, selectorX, selectorY + selectorHeight, -1);
        context.method_25294(selectorX + selectorWidth, selectorY, selectorX + selectorWidth + 1, selectorY + selectorHeight, -1);
        context.method_44379(selectorX, selectorY, selectorX + selectorWidth, selectorY + selectorHeight);
        int yOffset = 5 - this.selectorScrollOffset;
        for (WhiteboardData wb : this.savedWhiteboards) {
            int itemY = selectorY + yOffset;
            if (itemY + 20 >= selectorY && itemY <= selectorY + selectorHeight) {
                boolean hovering = mouseX >= selectorX && mouseX <= selectorX + selectorWidth && mouseY >= itemY && mouseY <= itemY + 20 && mouseY >= selectorY && mouseY <= selectorY + selectorHeight;
                boolean isCurrent = wb.getName().equals(this.currentWhiteboard.getName());
                if (isCurrent) {
                    context.method_25294(selectorX + 2, itemY, selectorX + selectorWidth - 2, itemY + 20, -2147418368);
                } else if (hovering) {
                    context.method_25294(selectorX + 2, itemY, selectorX + selectorWidth - 2, itemY + 20, 0x40FFFFFF);
                }
                context.method_51433(this.field_22793, wb.getName(), selectorX + 5, itemY + 6, -1, false);
            }
            yOffset += 25;
        }
        context.method_44380();
        if (maxScroll > 0) {
            if (this.selectorScrollOffset > 0) {
                context.method_51433(this.field_22793, "^", selectorX + selectorWidth - 15, selectorY + 5, -1, false);
            }
            if (this.selectorScrollOffset < maxScroll) {
                context.method_51433(this.field_22793, "v", selectorX + selectorWidth - 15, selectorY + selectorHeight - 15, -1, false);
            }
        }
    }

    private void renderStrokes(class_332 context) {
        if (this.needsRedraw) {
            this.updatePixelBuffer();
            this.needsRedraw = false;
        }
        for (int y = 0; y < this.canvasHeight; ++y) {
            int startX = -1;
            int currentColor = 0;
            for (int x = 0; x <= this.canvasWidth; ++x) {
                int color;
                int n = color = x < this.canvasWidth ? this.canvasPixels[x][y] : -1;
                if (color != -1) {
                    if (startX == -1) {
                        startX = x;
                        currentColor = color;
                        continue;
                    }
                    if (color == currentColor) continue;
                    context.method_25294(this.canvasX + startX, this.canvasY + y, this.canvasX + x, this.canvasY + y + 1, currentColor);
                    startX = x;
                    currentColor = color;
                    continue;
                }
                if (startX == -1) continue;
                context.method_25294(this.canvasX + startX, this.canvasY + y, this.canvasX + x, this.canvasY + y + 1, currentColor);
                startX = -1;
            }
        }
        if (this.currentStroke != null && !this.currentTool.isFillTool()) {
            List<WhiteboardData.DrawingStroke.Point> points = this.currentStroke.getPoints();
            for (int i = 0; i < points.size() - 1; ++i) {
                WhiteboardData.DrawingStroke.Point p1 = points.get(i);
                WhiteboardData.DrawingStroke.Point p2 = points.get(i + 1);
                this.drawLine(context, p1.getX(), p1.getY(), p2.getX(), p2.getY(), this.currentStroke.getColor(), this.currentStroke.getSize());
            }
        }
    }

    private void updatePixelBuffer() {
        for (int x = 0; x < this.canvasWidth; ++x) {
            for (int y = 0; y < this.canvasHeight; ++y) {
                this.canvasPixels[x][y] = -1;
            }
        }
        for (WhiteboardData.DrawingStroke stroke : this.currentWhiteboard.getStrokes()) {
            List<WhiteboardData.DrawingStroke.Point> points = stroke.getPoints();
            if (stroke.getSize() == 1 && points.size() > 100) {
                for (WhiteboardData.DrawingStroke.Point point : points) {
                    int px = point.getX() - this.canvasX;
                    int py = point.getY() - this.canvasY;
                    if (px < 0 || px >= this.canvasWidth || py < 0 || py >= this.canvasHeight) continue;
                    this.canvasPixels[px][py] = stroke.getColor();
                }
                continue;
            }
            for (int i = 0; i < points.size() - 1; ++i) {
                WhiteboardData.DrawingStroke.Point p1 = points.get(i);
                WhiteboardData.DrawingStroke.Point p2 = points.get(i + 1);
                this.drawLineToBuffer(p1.getX(), p1.getY(), p2.getX(), p2.getY(), stroke.getColor(), stroke.getSize());
            }
        }
    }

    private void drawLineToBuffer(int x1, int y1, int x2, int y2, int color, int size) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            this.drawCircleToBuffer(x, y, size, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    private void drawCircleToBuffer(int centerX, int centerY, int size, int color) {
        int radius = size / 2;
        for (int dy = -radius; dy <= radius; ++dy) {
            for (int dx = -radius; dx <= radius; ++dx) {
                if (dx * dx + dy * dy > radius * radius) continue;
                int px = centerX - this.canvasX + dx;
                int py = centerY - this.canvasY + dy;
                if (px < 0 || px >= this.canvasWidth || py < 0 || py >= this.canvasHeight) continue;
                this.canvasPixels[px][py] = color;
            }
        }
    }

    private void drawLine(class_332 context, int x1, int y1, int x2, int y2, int color, int size) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            this.drawCircle(context, x, y, size, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    private void drawCircle(class_332 context, int centerX, int centerY, int size, int color) {
        int radius = size / 2;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                if (x * x + y * y > radius * radius) continue;
                context.method_25294(centerX + x, centerY + y, centerX + x + 1, centerY + y + 1, color);
            }
        }
    }

    public boolean method_25402(class_11909 click, boolean doubleClick) {
        if (click.method_74245() == 0) {
            int mx = (int)click.comp_4798();
            int my = (int)click.comp_4799();
            if (this.showWhiteboardSelector) {
                int selectorWidth = 200;
                int selectorHeight = Math.min(300, this.savedWhiteboards.size() * 25 + 10);
                int selectorX = 10;
                int selectorY = this.topBarHeight + 5;
                if (mx >= selectorX && mx <= selectorX + selectorWidth && my >= selectorY && my <= selectorY + selectorHeight) {
                    int yOffset = 5 - this.selectorScrollOffset;
                    for (WhiteboardData wb : this.savedWhiteboards) {
                        int itemY = selectorY + yOffset;
                        if (my >= itemY && my <= itemY + 20 && my >= selectorY && my <= selectorY + selectorHeight) {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                            this.currentWhiteboard = wb;
                            this.showWhiteboardSelector = false;
                            this.selectorScrollOffset = 0;
                            this.needsRedraw = true;
                            return true;
                        }
                        yOffset += 25;
                    }
                } else {
                    this.showWhiteboardSelector = false;
                    return true;
                }
            }
            int nameWidth = this.field_22793.method_1727(this.currentWhiteboard.getName()) + 20;
            if (mx >= 10 && mx <= 10 + nameWidth && my >= 10 && my <= 30) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.showWhiteboardSelector = !this.showWhiteboardSelector;
                return true;
            }
            int newButtonX = this.field_22789 - 120;
            int newButtonY = 10;
            int newButtonSize = 20;
            if (mx >= newButtonX && mx <= newButtonX + newButtonSize && my >= newButtonY && my <= newButtonY + newButtonSize) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.createNewWhiteboard();
                return true;
            }
            int saveButtonX = this.field_22789 - 90;
            int saveButtonY = 10;
            int saveButtonWidth = 80;
            int saveButtonHeight = 20;
            if (mx >= saveButtonX && mx <= saveButtonX + saveButtonWidth && my >= saveButtonY && my <= saveButtonY + saveButtonHeight) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.saveWhiteboard();
                return true;
            }
            int clearButtonX = this.field_22789 - 220;
            int clearButtonY = 10;
            int clearButtonWidth = 80;
            int clearButtonHeight = 20;
            if (mx >= clearButtonX && mx <= clearButtonX + clearButtonWidth && my >= clearButtonY && my <= clearButtonY + clearButtonHeight) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.clearWhiteboard();
                return true;
            }
            DrawingTool[] tools = DrawingTool.values();
            int availableHeight = this.field_22790 - this.toolPanelY - 10;
            for (int i = 0; i < tools.length; ++i) {
                int buttonY = this.toolPanelY + i * (this.toolButtonSize + 5) - this.toolScrollOffset;
                if (buttonY + this.toolButtonSize < this.toolPanelY || buttonY > this.toolPanelY + availableHeight || mx < this.toolPanelX || mx > this.toolPanelX + this.toolButtonSize || my < buttonY || my > buttonY + this.toolButtonSize || my < this.toolPanelY || my > this.toolPanelY + availableHeight) continue;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.currentTool = tools[i];
                if (!this.currentTool.isFillTool()) {
                    this.fillColor = this.currentTool.getColor();
                }
                return true;
            }
            if (mx >= this.canvasX && mx <= this.canvasX + this.canvasWidth && my >= this.canvasY && my <= this.canvasY + this.canvasHeight) {
                this.startDrawing(mx, my);
                return true;
            }
        }
        return super.method_25402(click, doubleClick);
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (click.method_74245() == 0 && this.isDrawing) {
            int mx = (int)click.comp_4798();
            int my = (int)click.comp_4799();
            mx = Math.max(this.canvasX, Math.min(this.canvasX + this.canvasWidth, mx));
            my = Math.max(this.canvasY, Math.min(this.canvasY + this.canvasHeight, my));
            this.continueDrawing(mx, my);
            return true;
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.isDrawing) {
            this.stopDrawing();
            return true;
        }
        return super.method_25406(click);
    }

    private void startDrawing(int x, int y) {
        if (this.currentTool.isFillTool()) {
            this.floodFill(x, y, this.fillColor);
        } else {
            this.isDrawing = true;
            this.currentStroke = new WhiteboardData.DrawingStroke(this.currentTool.getColor(), this.currentTool.getSize());
            this.currentStroke.addPoint(x, y);
        }
    }

    private void continueDrawing(int x, int y) {
        if (this.currentStroke != null) {
            this.currentStroke.addPoint(x, y);
        }
    }

    private void stopDrawing() {
        if (this.currentStroke != null && this.currentStroke.getPoints().size() > 1) {
            List<WhiteboardData.DrawingStroke.Point> points = this.currentStroke.getPoints();
            for (int i = 0; i < points.size() - 1; ++i) {
                WhiteboardData.DrawingStroke.Point p1 = points.get(i);
                WhiteboardData.DrawingStroke.Point p2 = points.get(i + 1);
                this.drawLineToBuffer(p1.getX(), p1.getY(), p2.getX(), p2.getY(), this.currentStroke.getColor(), this.currentStroke.getSize());
            }
            this.currentWhiteboard.addStroke(this.currentStroke);
        }
        this.currentStroke = null;
        this.isDrawing = false;
    }

    private void createNewWhiteboard() {
        int count = this.savedWhiteboards.size() + 1;
        this.currentWhiteboard = new WhiteboardData("Whiteboard " + count);
        this.needsRedraw = true;
    }

    private void saveWhiteboard() {
        this.currentWhiteboard.save();
        this.loadSavedWhiteboards();
    }

    private void clearWhiteboard() {
        this.currentWhiteboard.clear();
        for (int x = 0; x < this.canvasWidth; ++x) {
            for (int y = 0; y < this.canvasHeight; ++y) {
                this.canvasPixels[x][y] = -1;
            }
        }
        this.needsRedraw = false;
    }

    private void floodFill(int x, int y, int fillColor) {
        int bufferX = x - this.canvasX;
        int bufferY = y - this.canvasY;
        if (bufferX < 0 || bufferX >= this.canvasWidth || bufferY < 0 || bufferY >= this.canvasHeight) {
            return;
        }
        int targetColor = this.canvasPixels[bufferX][bufferY];
        if (targetColor == fillColor) {
            return;
        }
        WhiteboardData.DrawingStroke fillStroke = new WhiteboardData.DrawingStroke(fillColor, 1);
        LinkedList<int[]> queue = new LinkedList<int[]>();
        HashSet<CallSite> visited = new HashSet<CallSite>();
        queue.add(new int[]{bufferX, bufferY});
        visited.add((CallSite)((Object)(bufferX + "," + bufferY)));
        while (!queue.isEmpty() && visited.size() < 100000) {
            int[][] directions;
            int[] point = (int[])queue.poll();
            int px = point[0];
            int py = point[1];
            if (px < 0 || px >= this.canvasWidth || py < 0 || py >= this.canvasHeight || this.canvasPixels[px][py] != targetColor) continue;
            this.canvasPixels[px][py] = fillColor;
            fillStroke.addPoint(this.canvasX + px, this.canvasY + py);
            for (int[] dir : directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
                int nx = px + dir[0];
                int ny = py + dir[1];
                String key = nx + "," + ny;
                if (visited.contains(key)) continue;
                visited.add((CallSite)((Object)key));
                queue.add(new int[]{nx, ny});
            }
        }
        if (fillStroke.getPoints().size() > 0) {
            this.currentWhiteboard.addStroke(fillStroke);
        }
        this.needsRedraw = false;
    }

    private int getPixelColor(int x, int y) {
        int bufferX = x - this.canvasX;
        int bufferY = y - this.canvasY;
        if (bufferX < 0 || bufferX >= this.canvasWidth || bufferY < 0 || bufferY >= this.canvasHeight) {
            return -1;
        }
        return this.canvasPixels[bufferX][bufferY];
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.showWhiteboardSelector) {
            int selectorWidth = 200;
            int maxSelectorHeight = 300;
            int selectorX = 10;
            int selectorY = this.topBarHeight + 5;
            int totalContentHeight = this.savedWhiteboards.size() * 25 + 10;
            int selectorHeight = Math.min(maxSelectorHeight, totalContentHeight);
            if (mx >= selectorX && mx <= selectorX + selectorWidth && my >= selectorY && my <= selectorY + selectorHeight) {
                this.selectorScrollOffset -= (int)(verticalAmount * 20.0);
                int maxScroll = Math.max(0, totalContentHeight - selectorHeight);
                this.selectorScrollOffset = Math.max(0, Math.min(this.selectorScrollOffset, maxScroll));
                return true;
            }
        }
        int availableHeight = this.field_22790 - this.toolPanelY - 10;
        if (mx >= this.toolPanelX && mx <= this.toolPanelX + this.toolPanelWidth && my >= this.toolPanelY && my <= this.toolPanelY + availableHeight) {
            this.toolScrollOffset -= (int)(verticalAmount * 20.0);
            this.toolScrollOffset = Math.max(0, Math.min(this.toolScrollOffset, this.maxToolScroll));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(class_11908 keyInput) {
        if (keyInput.comp_4795() == 256) {
            if (this.showWhiteboardSelector) {
                this.showWhiteboardSelector = false;
                return true;
            }
            this.method_25419();
            return true;
        }
        return super.method_25404(keyInput);
    }

    public boolean method_25421() {
        return false;
    }
}

