/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.item;

import com.themastergeneral.ctdcore.helpers.CTDConstants;
import com.themastergeneral.ctdcore.helpers.ModUtils;
import com.themastergeneral.ctdcore.item.CTDItem;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CTDDurabilityItem
extends CTDItem {
    public CTDDurabilityItem(Item.Properties properties, int durability) {
        super(properties.durability(durability).stacksTo(1));
    }

    public CTDDurabilityItem(int durability) {
        super(new Item.Properties().durability(durability).stacksTo(1));
    }

    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        ItemStack stack = itemStack.copy();
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        if (stack.getMaxDamage() != CTDConstants.creativeDurability) {
            stack.hurtAndBreak(1, null, null);
        }
        return stack.copy();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext p_333372_, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.isDamageableItem()) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)ModUtils.displayString("Durability: " + ModUtils.returnFormattedNumber(stack.getDamageValue()) + "/" + ModUtils.returnFormattedNumber(stack.getMaxDamage())));
            } else {
                tooltip.add((Component)ModUtils.displayString("Durability: " + ModUtils.returnShortenedNumber(stack.getDamageValue()) + "/" + ModUtils.returnShortenedNumber(stack.getMaxDamage())));
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        if (stack.isEnchanted()) {
            return true;
        }
        return stack.getMaxDamage() == CTDConstants.creativeDurability;
    }
}

