/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.item;

import com.themastergeneral.ctdcore.helpers.ModUtils;
import com.themastergeneral.ctdcore.item.CTDItem;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.FuelValues;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CTDFuelItem
extends CTDItem {
    private final int burnTicks;

    public CTDFuelItem(Item.Properties properties, int burnTicks) {
        super(properties);
        this.burnTicks = burnTicks;
    }

    public CTDFuelItem(int burnTicks) {
        super(new Item.Properties());
        this.burnTicks = burnTicks;
    }

    public CTDFuelItem(int maxStackSize, int burnTicks) {
        super(new Item.Properties().stacksTo(maxStackSize));
        this.burnTicks = burnTicks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.getBurnTime(null, context.level().fuelValues()) > 0) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)ModUtils.displayString("Burn Ticks: " + ModUtils.returnFormattedNumber(stack.getBurnTime(null, context.level().fuelValues()))));
            } else {
                tooltip.add((Component)ModUtils.displayString("Burn Ticks: " + ModUtils.returnShortenedNumber(stack.getBurnTime(null, context.level().fuelValues()))));
            }
        }
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return this.burnTicks;
    }
}

