/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.helpers;

import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StackHelper {
    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.isEmpty();
    }

    public static int getStackSize(ItemStack stack) {
        if (!StackHelper.isValid(stack)) {
            return 0;
        }
        return stack.getCount();
    }

    public static boolean isOnCooldown(Player player, ItemStack stack) {
        return player.getCooldowns().isOnCooldown(stack);
    }

    public static void hurtStackAddCooldown(Player player, ItemStack stack, int cooldown) {
        stack.hurtAndBreak(1, (LivingEntity)player, Objects.requireNonNull(stack.getEquipmentSlot()));
        if (cooldown > 0) {
            player.getCooldowns().addCooldown(stack, cooldown);
        }
    }

    public static void hurtStack(Player player, ItemStack stack) {
        StackHelper.hurtStackAddCooldown(player, stack, 0);
    }
}

