/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorldHelper {
    public static Block findBlockUnderEntity(Entity e) {
        int blockX = e.getBlockX();
        int blockY = e.getBlockY();
        int blockZ = e.getBlockZ();
        BlockPos blockpos = new BlockPos(blockX, blockY, blockZ);
        return e.level().getBlockState(blockpos).getBlock();
    }

    public static boolean isRaining(Level level) {
        return level.isRaining();
    }

    public static boolean isStorming(Level level) {
        return level.isThundering();
    }

    public static boolean isDaytime(Level level) {
        return level.isBrightOutside();
    }

    public static boolean isNighttime(Level level) {
        return level.isDarkOutside();
    }

    public static boolean isClearDaytime(Level level) {
        return WorldHelper.isDaytime(level) && !WorldHelper.isRaining(level) && !WorldHelper.isStorming(level);
    }

    public static boolean isClearNighttime(Level level) {
        return WorldHelper.isNighttime(level) && !WorldHelper.isRaining(level) && !WorldHelper.isStorming(level);
    }
}

