/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.item;

import com.themastergeneral.ctdcore.helpers.CTDConstants;
import com.themastergeneral.ctdcore.item.CTDItem;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CTDDurabilityItem
extends CTDItem {
    public CTDDurabilityItem(ResourceKey<Item> key, Item.Properties properties, int durability) {
        super(key, properties.durability(durability).stacksTo(1));
    }

    public CTDDurabilityItem(ResourceKey<Item> key, int durability) {
        super(key, new Item.Properties().durability(durability).stacksTo(1));
    }

    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        ItemStack stack = itemStack.copy();
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        if (stack.getMaxDamage() != CTDConstants.creativeDurability) {
            stack.hurtAndBreak(1, null, Objects.requireNonNull(stack.getEquipmentSlot()));
        }
        return stack.copy();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean isFoil(ItemStack stack) {
        if (stack.isEnchanted()) {
            return true;
        }
        return stack.getMaxDamage() == CTDConstants.creativeDurability;
    }
}

