/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bandits.init;

import net.mcreator.bandits.entity.BanditEmptyEntity;
import net.mcreator.bandits.entity.BanditFullEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class BanditsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"bandits");
    public static final DeferredHolder<EntityType<?>, EntityType<BanditEmptyEntity>> BANDIT_EMPTY = BanditsModEntities.register("bandit_empty", EntityType.Builder.of(BanditEmptyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<BanditFullEntity>> BANDIT_FULL = BanditsModEntities.register("bandit_full", EntityType.Builder.of(BanditFullEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.95f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bandits", (String)registryname))));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)BANDIT_FULL.get(), (living, context) -> living.getCombinedInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        BanditEmptyEntity.init(event);
        BanditFullEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BANDIT_EMPTY.get(), BanditEmptyEntity.createAttributes().build());
        event.put((EntityType)BANDIT_FULL.get(), BanditFullEntity.createAttributes().build());
    }
}

