/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bandits.procedures;

import java.util.Comparator;
import net.mcreator.bandits.entity.BanditEmptyEntity;
import net.mcreator.bandits.init.BanditsModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class BanditFullOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        Entity myEntity = null;
        if (!world.isClientSide()) {
            ItemStack itemStack;
            Object object = entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
            if (object instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable _modHandler1 = (IItemHandlerModifiable)object;
                itemStack = _modHandler1.getStackInSlot(0).copy();
            } else {
                itemStack = ItemStack.EMPTY;
            }
            if (itemStack.getItem() == ItemStack.EMPTY.getItem()) {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    Entity entityToSpawn = ((EntityType)BanditsModEntities.BANDIT_EMPTY.get()).spawn(_level, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), EntitySpawnReason.MOB_SUMMONED);
                    if (entityToSpawn != null) {
                        entityToSpawn.setYRot(entity.getYRot());
                        entityToSpawn.setYBodyRot(entity.getYRot());
                        entityToSpawn.setYHeadRot(entity.getYRot());
                        entityToSpawn.setXRot(entity.getXRot());
                        entityToSpawn.setDeltaMovement(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z());
                    }
                }
                if (!world.getEntitiesOfClass(BanditEmptyEntity.class, new AABB(Vec3.ZERO, Vec3.ZERO).move(new Vec3(entity.getX(), entity.getY(), entity.getZ())).inflate(2.5), e -> true).isEmpty()) {
                    myEntity = BanditFullOnEntityTickUpdateProcedure.findEntityInWorldRange(world, BanditEmptyEntity.class, entity.getX(), entity.getY(), entity.getZ(), 5.0);
                    if (myEntity instanceof LivingEntity) {
                        float f;
                        LivingEntity _entity = (LivingEntity)myEntity;
                        if (entity instanceof LivingEntity) {
                            LivingEntity _livEnt = (LivingEntity)entity;
                            f = _livEnt.getHealth();
                        } else {
                            f = -1.0f;
                        }
                        _entity.setHealth(f);
                    }
                    myEntity.setAirSupply(entity.getAirSupply());
                    Entity _ent = myEntity;
                    _ent.setYRot(entity.getYRot());
                    _ent.setXRot(entity.getXRot());
                    _ent.setYBodyRot(_ent.getYRot());
                    _ent.setYHeadRot(_ent.getYRot());
                    _ent.yRotO = _ent.getYRot();
                    _ent.xRotO = _ent.getXRot();
                    if (_ent instanceof LivingEntity) {
                        LivingEntity _entity = (LivingEntity)_ent;
                        _entity.yBodyRotO = _entity.getYRot();
                        _entity.yHeadRotO = _entity.getYRot();
                    }
                    if (entity.isOnFire()) {
                        myEntity.igniteForSeconds((float)(entity.getRemainingFireTicks() / 20));
                    }
                    myEntity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z()));
                }
                if (!entity.level().isClientSide()) {
                    entity.discard();
                }
            }
        }
    }

    private static Entity findEntityInWorldRange(LevelAccessor world, Class<? extends Entity> clazz, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(clazz, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).findFirst().orElse(null);
    }
}

