/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.api;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.interfaces.WootSpawnProperties;

public abstract class WootUpgradeItem
extends Item {
    protected final int level;

    public WootUpgradeItem(Item.Properties properties, int level) {
        super(properties);
        this.level = level;
    }

    public void initUpgradeTag(CompoundTag upgradeTag, HolderLookup.Provider lookupProvider) {
    }

    @Deprecated(since="1.1.4", forRemoval=true)
    public void applyGenerationProperties(WootGenerationProperties properties) {
    }

    @ApiStatus.AvailableSince(value="1.1.4")
    public void applyGenerationProperties(WootGenerationProperties properties, CompoundTag upgradeTag) {
        this.applyGenerationProperties(properties);
    }

    @Deprecated(since="1.1.4", forRemoval=true)
    public void applySpawnProperties(WootSpawnProperties properties) {
    }

    @ApiStatus.AvailableSince(value="1.1.4")
    public void applySpawnProperties(WootSpawnProperties properties, CompoundTag upgradeTag) {
        this.applySpawnProperties(properties);
    }

    @Deprecated(since="1.1.4", forRemoval=true)
    public void modifyDrops(WootDropsProperties properties) {
    }

    @ApiStatus.AvailableSince(value="1.1.4")
    public void modifyDrops(WootDropsProperties properties, CompoundTag upgradeTag) {
    }

    public int getLevel() {
        return this.level;
    }

    public ResourceLocation getTextureLocation() {
        return ForgeRegistries.ITEMS.getKey((Object)this).m_246208_("textures/item/").m_266382_(".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyUpgradeTexture(NativeImage upgradeSide, NativeImage upgradeItem) {
        for (int y = 2; y < 14; ++y) {
            for (int x = 2; x < 14; ++x) {
                int color = upgradeItem.m_84985_(x, y);
                int alpha = color >> 24;
                if (alpha == 0) continue;
                upgradeSide.m_84988_(x, y, color);
            }
        }
    }
}

