/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.api.enums;

import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum Tier implements StringRepresentable
{
    INVALID,
    TIER_1,
    TIER_2,
    TIER_3,
    TIER_4,
    TIER_5;

    private static final EnumSet<Tier> MOB_VALID_FOR_TIER_1;
    private static final EnumSet<Tier> MOB_VALID_FOR_TIER_2;
    private static final EnumSet<Tier> MOB_VALID_FOR_TIER_3;
    private static final EnumSet<Tier> MOB_VALID_FOR_TIER_4;
    private static final EnumSet<Tier> MOB_VALID_FOR_TIER_5;
    private static final EnumSet<Tier> FACTORY_VALID_FOR_TIER_1;
    private static final EnumSet<Tier> FACTORY_VALID_FOR_TIER_2;
    private static final EnumSet<Tier> FACTORY_VALID_FOR_TIER_3;
    private static final EnumSet<Tier> FACTORY_VALID_FOR_TIER_4;
    private static final EnumSet<Tier> FACTORY_VALID_FOR_TIER_5;

    public int defaultVitalityCost() {
        if (this == TIER_1) {
            return 1500;
        }
        if (this == TIER_2) {
            return 3500;
        }
        if (this == TIER_3) {
            return 7500;
        }
        if (this == TIER_4) {
            return 15000;
        }
        if (this == TIER_5) {
            return 30000;
        }
        return 0;
    }

    public boolean isMobTierValid(Tier tier) {
        if (this == TIER_1) {
            return MOB_VALID_FOR_TIER_1.contains((Object)tier);
        }
        if (this == TIER_2) {
            return MOB_VALID_FOR_TIER_2.contains((Object)tier);
        }
        if (this == TIER_3) {
            return MOB_VALID_FOR_TIER_3.contains((Object)tier);
        }
        if (this == TIER_4) {
            return MOB_VALID_FOR_TIER_4.contains((Object)tier);
        }
        if (this == TIER_5) {
            return MOB_VALID_FOR_TIER_5.contains((Object)tier);
        }
        return false;
    }

    public boolean isFactoryTierValid(Tier tier) {
        if (this == TIER_1) {
            return FACTORY_VALID_FOR_TIER_1.contains((Object)tier);
        }
        if (this == TIER_2) {
            return FACTORY_VALID_FOR_TIER_2.contains((Object)tier);
        }
        if (this == TIER_3) {
            return FACTORY_VALID_FOR_TIER_3.contains((Object)tier);
        }
        if (this == TIER_4) {
            return FACTORY_VALID_FOR_TIER_4.contains((Object)tier);
        }
        if (this == TIER_5) {
            return FACTORY_VALID_FOR_TIER_5.contains((Object)tier);
        }
        return false;
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        MOB_VALID_FOR_TIER_1 = EnumSet.of(TIER_1);
        MOB_VALID_FOR_TIER_2 = EnumSet.range(TIER_1, TIER_2);
        MOB_VALID_FOR_TIER_3 = EnumSet.range(TIER_1, TIER_3);
        MOB_VALID_FOR_TIER_4 = EnumSet.range(TIER_1, TIER_4);
        MOB_VALID_FOR_TIER_5 = EnumSet.range(TIER_1, TIER_5);
        FACTORY_VALID_FOR_TIER_1 = EnumSet.range(TIER_1, TIER_5);
        FACTORY_VALID_FOR_TIER_2 = EnumSet.range(TIER_2, TIER_5);
        FACTORY_VALID_FOR_TIER_3 = EnumSet.range(TIER_3, TIER_5);
        FACTORY_VALID_FOR_TIER_4 = EnumSet.range(TIER_4, TIER_5);
        FACTORY_VALID_FOR_TIER_5 = EnumSet.of(TIER_5);
    }
}

