/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.cell;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.cell.CellBlockEntity;
import wootrevived.woot.config.CellConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBase;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class CellBlock
extends FactoryBlockBase {
    protected StateDefinition<Block, BlockState> cellStateDefinition;

    public CellBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.cellStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.cellStateDefinition;
    }

    @Override
    public boolean verifyItem(Item item) {
        return item == BlocksRegistry.COPPER_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.IRON_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.GOLD_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.DIAMOND_CELL_BLOCK_ITEM.get() || item == BlocksRegistry.NETHERITE_CELL_BLOCK_ITEM.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter block, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_5871_(stack, block, tooltip, flag);
        int capacity = 0;
        if (this.entity.get() == BlocksRegistry.COPPER_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.COPPER_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.IRON_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.IRON_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.GOLD_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.GOLD_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.DIAMOND_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.DIAMOND_CAPACITY.get();
        } else if (this.entity.get() == BlocksRegistry.NETHERITE_CELL_BLOCK_ENTITY.get()) {
            capacity = (Integer)CellConfig.NETHERITE_CAPACITY.get();
        }
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("InputTank")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("InputTank"));
            tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.cell.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(capacity)).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
        }
    }

    public static class State
    extends FactoryBlockBase.State {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return InteractionResult.PASS;
            }
            if (!(level.m_7702_(hit.m_82425_()) instanceof CellBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            ItemStack heldItem = player.m_21120_(hand);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.m_82425_(), (Direction)hit.m_82434_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return super.m_60664_(level, player, hand, hit);
        }
    }
}

