/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.cell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.config.CellConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CellBlockEntity
extends FactoryBlockBaseEntity {
    public final WootFluidTankHandler tankHandler = this.createTank();
    public final LazyOptional<WootFluidTankHandler> tank = LazyOptional.of(() -> this.tankHandler);

    public CellBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
        this.tankHandler.setCapacity(this.getCapacity());
    }

    private WootFluidTankHandler createTank() {
        return new WootFluidTankHandler(1000, false, stack -> stack.isFluidEqual(new FluidStack((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get(), 1))){

            protected void onContentsChanged() {
                CellBlockEntity.this.m_6596_();
            }
        };
    }

    private int getCapacity() {
        if (this.m_58903_() == BlocksRegistry.COPPER_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.COPPER_CAPACITY.get();
        }
        if (this.m_58903_() == BlocksRegistry.IRON_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.IRON_CAPACITY.get();
        }
        if (this.m_58903_() == BlocksRegistry.GOLD_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.GOLD_CAPACITY.get();
        }
        if (this.m_58903_() == BlocksRegistry.DIAMOND_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.DIAMOND_CAPACITY.get();
        }
        if (this.m_58903_() == BlocksRegistry.NETHERITE_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.NETHERITE_CAPACITY.get();
        }
        return 0;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue() && ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            return this.tank.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InputTank", (Tag)this.tankHandler.writeToNBT(new CompoundTag()));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.tankHandler.readFromNBT(tag.m_128469_("InputTank"));
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

