/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_tank;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.creative_tank.CreativeTankBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;

public class CreativeTankBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> creativeTankStateDefinition;

    public CreativeTankBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_(stateDefinitionBuilder);
        this.creativeTankStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)this.m_49965_().m_61090_());
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.creativeTankStateDefinition;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return blockEntityType == BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get() ? CreativeTankBlockEntity::ticker : null;
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(hit.m_82425_());
            if (!(blockEntity instanceof CreativeTankBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            CreativeTankBlockEntity createTankBlockEntity = (CreativeTankBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                FluidStack stack = FluidUtil.getFluidHandler((ItemStack)heldItem).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                createTankBlockEntity.emptyIfDifferentFluidStack(stack);
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.m_82425_(), (Direction)hit.m_82434_())) {
                    createTankBlockEntity.setMaxCapacity();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
    }
}

