/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_tank;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CreativeTankBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    public WootFluidTankHandler inputTankHandler = this.createInputTank();
    public LazyOptional<WootFluidTankHandler> inputTank = LazyOptional.of(() -> this.inputTankHandler);

    public CreativeTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    private WootFluidTankHandler createInputTank() {
        return new WootFluidTankHandler(Integer.MAX_VALUE, false){

            protected void onContentsChanged() {
                if (!this.getFluid().isEmpty()) {
                    this.getFluid().setAmount(Integer.MAX_VALUE);
                }
                CreativeTankBlockEntity.this.m_6596_();
            }
        };
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof CreativeTankBlockEntity) {
            CreativeTankBlockEntity creativeTankBlockEntity = (CreativeTankBlockEntity)blockEntity;
            creativeTankBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    public void m_155252_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        for (Direction facing : Direction.values()) {
            BlockEntity be = level.m_7702_(this.m_58899_().m_121945_(facing));
            if (be == null) continue;
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(tank -> tank.fill(new FluidStack(this.inputTankHandler.getFluid().getFluid(), tank.getTankCapacity(0)), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    public void setMaxCapacity() {
        this.inputTankHandler.getFluid().setAmount(Integer.MAX_VALUE);
        this.m_6596_();
    }

    public void emptyIfDifferentFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!this.inputTankHandler.getFluid().isFluidEqual(fluidStack)) {
            this.inputTankHandler.setFluid(FluidStack.EMPTY);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.inputTank.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InputTank", (Tag)this.inputTankHandler.writeToNBT(new CompoundTag()));
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.inputTankHandler.readFromNBT(tag.m_128469_("InputTank"));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

