/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.dye_liquifier;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerMenu;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.recipes.WootContainer;

public class DyeLiquifierBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    private final List<Map<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(5);
    public static final int OUTPUT_FLUID_PROPERTY = 0;
    public static final int RED_INGREDIENT_PROPERTY = 1;
    public static final int YELLOW_INGREDIENT_PROPERTY = 2;
    public static final int BLUE_INGREDIENT_PROPERTY = 3;
    public static final int WHITE_INGREDIENT_PROPERTY = 4;
    public final WootItemStackHandler redInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.RED);
        }
    };
    public final WootItemStackHandler yellowInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.YELLOW);
        }
    };
    public final WootItemStackHandler blueInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.BLUE);
        }
    };
    public final WootItemStackHandler whiteInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.WHITE);
        }
    };
    public static int INPUT_SLOT = 0;
    private final IItemHandler allSlotsHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.redInventoryHandler, this.yellowInventoryHandler, this.blueInventoryHandler, this.whiteInventoryHandler});
    private final Map<Integer, DyeLiquifierRecipe> recipes = new HashMap<Integer, DyeLiquifierRecipe>();

    public DyeLiquifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.DYE_LIQUIFIER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 5; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof DyeLiquifierBlockEntity) {
            DyeLiquifierBlockEntity dyeLiquifierBlockEntity = (DyeLiquifierBlockEntity)blockEntity;
            dyeLiquifierBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    @Override
    public void m_155252_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.m_155252_(level, pos, state, blockEntity);
        if (level.f_46443_) {
            return;
        }
        this.generatePureFluid();
        this.tickFluid(this.outputTankHandler, pos, (Integer)DyeLiquifierConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.allSlotsHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        Properties properties = this.getProperties(side);
        if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            WootItemHandlerWrapper wrapper = new WootItemHandlerWrapper().addHandler(this.redInventoryHandler, properties::getRedIngredientProperty).addHandler(this.blueInventoryHandler, properties::getBlueIngredientProperty).addHandler(this.yellowInventoryHandler, properties::getYellowIngredientProperty).addHandler(this.whiteInventoryHandler, properties::getWhiteIngredientProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            WootFluidHandlerWrapper wrapper = new WootFluidHandlerWrapper().addHandler(this.outputTankHandler, properties::getOutputFluidProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("InputInventory")) {
            this.redInventoryHandler.deserializeNBT(tag.m_128469_("InputInventory"));
        }
        if (tag.m_128441_("RedInventory")) {
            this.redInventoryHandler.deserializeNBT(tag.m_128469_("RedInventory"));
        }
        if (tag.m_128441_("YellowInventory")) {
            this.yellowInventoryHandler.deserializeNBT(tag.m_128469_("YellowInventory"));
        }
        if (tag.m_128441_("BlueInventory")) {
            this.blueInventoryHandler.deserializeNBT(tag.m_128469_("BlueInventory"));
        }
        if (tag.m_128441_("WhiteInventory")) {
            this.whiteInventoryHandler.deserializeNBT(tag.m_128469_("WhiteInventory"));
        }
        if (tag.m_128441_("InternalTanks")) {
            CompoundTag dyeTag = tag.m_128469_("InternalTanks");
            this.red = dyeTag.m_128451_("Red");
            this.yellow = dyeTag.m_128451_("Yellow");
            this.blue = dyeTag.m_128451_("Blue");
            this.white = dyeTag.m_128451_("White");
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("RedInventory", (Tag)this.redInventoryHandler.serializeNBT());
        tag.m_128365_("YellowInventory", (Tag)this.yellowInventoryHandler.serializeNBT());
        tag.m_128365_("BlueInventory", (Tag)this.blueInventoryHandler.serializeNBT());
        tag.m_128365_("WhiteInventory", (Tag)this.whiteInventoryHandler.serializeNBT());
        CompoundTag dyeTag = new CompoundTag();
        dyeTag.m_128405_("Red", this.red);
        dyeTag.m_128405_("Yellow", this.yellow);
        dyeTag.m_128405_("Blue", this.blue);
        dyeTag.m_128405_("White", this.white);
        tag.m_128365_("InternalTanks", (Tag)dyeTag);
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.redInventoryHandler.getStackInSlot(INPUT_SLOT).m_41777_();
        if (!itemStack.m_41619_()) {
            drops.add(itemStack);
            this.redInventoryHandler.insertItem(INPUT_SLOT, ItemStack.f_41583_, false);
        }
        if (!(itemStack = this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT).m_41777_()).m_41619_()) {
            drops.add(itemStack);
            this.yellowInventoryHandler.insertItem(INPUT_SLOT, ItemStack.f_41583_, false);
        }
        if (!(itemStack = this.blueInventoryHandler.getStackInSlot(INPUT_SLOT).m_41777_()).m_41619_()) {
            drops.add(itemStack);
            this.blueInventoryHandler.insertItem(INPUT_SLOT, ItemStack.f_41583_, false);
        }
        if (!(itemStack = this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT).m_41777_()).m_41619_()) {
            drops.add(itemStack);
            this.whiteInventoryHandler.insertItem(INPUT_SLOT, ItemStack.f_41583_, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.woot_revived.dye_liquifier.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new DyeLiquifierContainerMenu(containerId, this.f_58857_, this.m_58899_(), playerInventory, player);
    }

    @Override
    public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
        this.recipes.clear();
    }

    @Override
    protected int getRecipeEnergy() {
        return this.recipes.values().stream().mapToInt(DyeLiquifierRecipe::getEnergy).sum();
    }

    private void generatePureFluid() {
        while (this.canCreateOutput() && this.canStoreOutput()) {
            this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
            this.red -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.yellow -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.blue -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.white -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.m_6596_();
        }
    }

    @Override
    protected void processFinished() {
        ItemStack item;
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            this.getRecipe();
        }
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            this.processOff();
            return;
        }
        for (DyeLiquifierRecipe recipe : this.recipes.values()) {
            this.red += recipe.getRed();
            this.yellow += recipe.getYellow();
            this.blue += recipe.getBlue();
            this.white += recipe.getWhite();
        }
        this.red = Mth.m_14045_((int)this.red, (int)0, (int)((Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get()));
        this.yellow = Mth.m_14045_((int)this.yellow, (int)0, (int)((Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get()));
        this.blue = Mth.m_14045_((int)this.blue, (int)0, (int)((Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get()));
        this.white = Mth.m_14045_((int)this.white, (int)0, (int)((Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get()));
        if (this.recipes.containsKey(0)) {
            item = this.redInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.m_41720_().hasCraftingRemainingItem(item)) {
                this.redInventoryHandler.setStackInSlot(INPUT_SLOT, item.m_41720_().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(0).ingredientCount(this.redInventoryHandler.getStackInSlot(INPUT_SLOT).m_41720_());
                this.redInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(1)) {
            item = this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.m_41720_().hasCraftingRemainingItem(item)) {
                this.yellowInventoryHandler.setStackInSlot(INPUT_SLOT, item.m_41720_().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(1).ingredientCount(this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT).m_41720_());
                this.yellowInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(2)) {
            item = this.blueInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.m_41720_().hasCraftingRemainingItem(item)) {
                this.blueInventoryHandler.setStackInSlot(INPUT_SLOT, item.m_41720_().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(2).ingredientCount(this.blueInventoryHandler.getStackInSlot(INPUT_SLOT).m_41720_());
                this.blueInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(3)) {
            item = this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.m_41720_().hasCraftingRemainingItem(item)) {
                this.whiteInventoryHandler.setStackInSlot(INPUT_SLOT, item.m_41720_().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(3).ingredientCount(this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT).m_41720_());
                this.whiteInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        this.m_6596_();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            return false;
        }
        int red = 0;
        int yellow = 0;
        int blue = 0;
        int white = 0;
        for (DyeLiquifierRecipe recipe : this.recipes.values()) {
            red += recipe.getRed();
            yellow += recipe.getYellow();
            blue += recipe.getBlue();
            white += recipe.getWhite();
        }
        return this.canStoreInternal(red, yellow, blue, white);
    }

    private void getRecipe() {
        DyeLiquifierRecipe r = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.left((Object)this.redInventoryHandler.getStackInSlot(INPUT_SLOT))), this.f_58857_).orElse(null);
        if (r != null) {
            this.recipes.put(0, r);
        } else {
            this.recipes.remove(0);
        }
        r = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.left((Object)this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT))), this.f_58857_).orElse(null);
        if (r != null) {
            this.recipes.put(1, r);
        } else {
            this.recipes.remove(1);
        }
        r = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.left((Object)this.blueInventoryHandler.getStackInSlot(INPUT_SLOT))), this.f_58857_).orElse(null);
        if (r != null) {
            this.recipes.put(2, r);
        } else {
            this.recipes.remove(2);
        }
        r = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.left((Object)this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT))), this.f_58857_).orElse(null);
        if (r != null) {
            this.recipes.put(3, r);
        } else {
            this.recipes.remove(3);
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getYellow() {
        return this.yellow;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getWhite() {
        return this.white;
    }

    private boolean canStoreInternal(int recipeRed, int recipeYellow, int recipeBlue, int recipeWhite) {
        boolean redHasSpace = recipeRed + this.red <= (Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get();
        boolean yellowHasSpace = recipeYellow + this.yellow <= (Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get();
        boolean blueHasSpace = recipeBlue + this.blue <= (Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get();
        boolean whiteHasSpace = recipeWhite + this.white <= (Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get();
        return recipeRed > 0 && redHasSpace || recipeYellow > 0 && yellowHasSpace || recipeBlue > 0 && blueHasSpace || recipeWhite > 0 && whiteHasSpace;
    }

    private boolean canCreateOutput() {
        return this.red >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.yellow >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.blue >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.white >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get();
    }

    private boolean canStoreOutput() {
        return this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue()), IFluidHandler.FluidAction.SIMULATE) == ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue();
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)DyeLiquifierConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasInputFluidCapability() {
        return false;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return null;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(DyeLiquifierBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getRedIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getYellowIngredientProperty() {
            return this.entity.directionsProperties.get(2).get((Object)this.machineSide);
        }

        public MachineSideProperty getBlueIngredientProperty() {
            return this.entity.directionsProperties.get(3).get((Object)this.machineSide);
        }

        public MachineSideProperty getWhiteIngredientProperty() {
            return this.entity.directionsProperties.get(4).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }
    }
}

