/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.enchanted_liquifier;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.enchanted_liquifier.EnchantedLiquifierContainerMenu;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.helper.EnchantmentHelper;

public class EnchantedLiquifierBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<Map<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(2);
    public static final int OUTPUT_FLUID_PROPERTY = 0;
    public static final int INGREDIENT_PROPERTY = 1;
    public final WootItemStackHandler inventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            EnchantedLiquifierBlockEntity.this.onContentsChanged(slot);
            EnchantedLiquifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == Items.f_42690_ && EnchantmentHelper.isEnchanted(stack);
        }
    };
    public static int INPUT_SLOT = 0;

    public EnchantedLiquifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 2; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof EnchantedLiquifierBlockEntity) {
            EnchantedLiquifierBlockEntity enchantedLiquifierBlockEntity = (EnchantedLiquifierBlockEntity)blockEntity;
            enchantedLiquifierBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    @Override
    public void m_155252_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.m_155252_(level, pos, state, blockEntity);
        if (level.f_46443_) {
            return;
        }
        this.tickFluid(this.outputTankHandler, pos, (Integer)EnchantedLiquifierConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        Properties properties = this.getProperties(side);
        if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            WootItemHandlerWrapper wrapper = new WootItemHandlerWrapper().addHandler(this.inventoryHandler, properties::getIngredientProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            WootFluidHandlerWrapper wrapper = new WootFluidHandlerWrapper().addHandler(this.outputTankHandler, properties::getOutputFluidProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("InputInventory")) {
            this.inventoryHandler.deserializeNBT(tag.m_128469_("InputInventory"));
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InputInventory", (Tag)this.inventoryHandler.serializeNBT());
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (!itemStack.m_41619_()) {
            drops.add(itemStack);
            this.inventoryHandler.insertItem(INPUT_SLOT, ItemStack.f_41583_, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.woot_revived.enchanted_liquifier.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EnchantedLiquifierContainerMenu(containerId, this.f_58857_, this.m_58899_(), playerInventory, player);
    }

    @Override
    public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
    }

    @Override
    protected int getRecipeEnergy() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.m_41619_()) {
            return 0;
        }
        return this.getEnchantEnergy(itemStack);
    }

    @Override
    protected void processFinished() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.m_41619_()) {
            return;
        }
        this.inventoryHandler.extractItem(INPUT_SLOT, 1, false);
        int amount = this.getEnchantAmount(itemStack);
        this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.EXECUTE);
        this.m_6596_();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        int filled;
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.m_41619_()) {
            return false;
        }
        if (!EnchantmentHelper.isEnchanted(itemStack)) {
            return false;
        }
        int amount = this.getEnchantAmount(itemStack);
        return amount == (filled = this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.SIMULATE));
    }

    private int getEnchantAmount(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.m_41619_() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListTag listNBT = itemStack.m_41720_() == Items.f_42690_ ? EnchantedBookItem.m_41163_((ItemStack)itemStack) : itemStack.m_41785_();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.m_128728_(i);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundNBT.m_128461_("id")));
                if (enchantment == null || !compoundNBT.m_128441_("lvl")) continue;
                amount += Mth.m_14045_((int)compoundNBT.m_128451_("lvl"), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_FLUID.get();
            }
        }
        return amount;
    }

    private int getEnchantEnergy(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.m_41619_() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListTag listNBT = itemStack.m_41720_() == Items.f_42690_ ? EnchantedBookItem.m_41163_((ItemStack)itemStack) : itemStack.m_41785_();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.m_128728_(i);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundNBT.m_128461_("id")));
                if (enchantment == null || !compoundNBT.m_128441_("lvl")) continue;
                amount += Mth.m_14045_((int)compoundNBT.m_128451_("lvl"), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_ENERGY.get();
            }
        }
        return amount;
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasInputFluidCapability() {
        return false;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return null;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)EnchantedLiquifierConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(EnchantedLiquifierBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }
    }
}

