/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory_upgrade;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.woot.client.model.factory_upgrade.FactoryUpgradeBakedModel;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.UpgradeItemsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;

public class FactoryUpgradeBlockEntity
extends FactoryBlockBaseEntity {
    private WootUpgradeItem upgradeItem = null;
    private CompoundTag upgradeNBT = new CompoundTag();

    public FactoryUpgradeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FACTORY_UPGRADE_BLOCK_ENTITY.get(), pos, state);
    }

    public void applyGenerationProperties(WootGenerationProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applyGenerationProperties(properties, this.upgradeNBT);
        }
    }

    public void applySpawnProperties(WootSpawnProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applySpawnProperties(properties, this.upgradeNBT);
        }
    }

    public void modifyDrops(WootDropsProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.modifyDrops(properties, this.upgradeNBT);
        }
    }

    public String getUpgradeItemName() {
        return this.upgradeItem == null ? "" : UpgradeItemsRegistry.getNameFromItem(this.upgradeItem);
    }

    public ItemStack getUpgradeItemStack() {
        return this.upgradeItem == null ? ItemStack.f_41583_ : this.upgradeItem.m_7968_();
    }

    public void addUpgrade(Level level, Player player, InteractionHand hand, ItemStack stack, WootUpgradeItem newUpgradeItem) {
        if (this.upgradeItem == newUpgradeItem) {
            return;
        }
        WootUpgradeItem oldUpgradeItem = this.upgradeItem;
        this.upgradeItem = newUpgradeItem;
        this.upgradeNBT = new CompoundTag();
        newUpgradeItem.initUpgradeTag(this.upgradeNBT, (HolderLookup.Provider)level.m_9598_());
        this.m_6596_();
        player.m_6674_(hand);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
            if (oldUpgradeItem != null) {
                if (stack.m_41619_()) {
                    player.m_21008_(hand, oldUpgradeItem.m_7968_());
                } else {
                    this.dropItem(level, player.m_20097_().m_7494_(), oldUpgradeItem);
                }
            }
        }
    }

    public void removeUpgrade(Level level, Player player, InteractionHand hand) {
        WootUpgradeItem oldUpgradeItem = this.upgradeItem;
        this.upgradeItem = null;
        this.upgradeNBT = new CompoundTag();
        this.m_6596_();
        player.m_6674_(hand);
        if (oldUpgradeItem != null) {
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, oldUpgradeItem.m_7968_());
            } else {
                this.dropItem(level, player.m_20097_().m_7494_(), oldUpgradeItem);
            }
        }
    }

    public void dropItem(Level level, BlockPos pos) {
        if (this.upgradeItem == null) {
            return;
        }
        this.dropItem(level, pos, this.upgradeItem);
    }

    public void dropItem(Level level, BlockPos pos, WootUpgradeItem upgradeItem) {
        ItemStack stack = upgradeItem.m_7968_();
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("UpgradeItem", (Tag)StringTag.m_129297_((String)this.getUpgradeItemName()));
        tag.m_128365_("UpgradeItemNBT", (Tag)this.upgradeNBT);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        String item;
        super.m_142466_(tag);
        this.upgradeItem = tag.m_128441_("UpgradeItem") ? (!(item = tag.m_128461_("UpgradeItem")).isEmpty() && UpgradeItemsRegistry.has(item) ? (WootUpgradeItem)((Object)UpgradeItemsRegistry.get(item).get()) : null) : null;
        if (tag.m_128441_("UpgradeItemNBT")) {
            this.upgradeNBT = tag.m_128469_("UpgradeItemNBT");
        }
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @NotNull
    public ModelData getModelData() {
        BlockState state = this.m_58900_();
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        BakedModel model = renderer.m_110910_(state);
        return model.getModelData((BlockAndTintGetter)this.f_58857_, this.m_58899_(), this.m_58900_(), super.getModelData());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRequestModelDataUpdate() {
        if (this.f_58857_ == null || this.f_58857_.getModelDataManager() == null) {
            return;
        }
        ModelData data = this.f_58857_.getModelDataManager().getAt(this.m_58899_());
        if (data != null && data.has(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)) {
            if (this.upgradeItem == null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).isEmpty()) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            } else if (this.upgradeItem != null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).equalsIgnoreCase(UpgradeItemsRegistry.getNameFromItem(this.upgradeItem))) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }
}

