/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fake_spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.network.NetworkChannel;
import wootrevived.woot.network.WootFakeSpawnerUpdate;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class FakeSpawnerBlockEntity
extends FactoryBlockBaseEntity {
    private CompoundTag mobTag = null;
    public int index;
    private int vitalityCost = 0;
    private int totalDrained = 0;
    private double perTickRatio = 0.0;
    private double accumulator = 0.0;
    private int numOfSim = 0;
    protected RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private boolean lastRedstoneState = false;

    public FakeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FAKE_SPAWNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public CompoundTag getMobTag() {
        return this.mobTag;
    }

    @Nullable
    public WootFactoryMob<?> getMob() {
        if (this.mobTag == null) {
            return null;
        }
        return WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
    }

    public int getNumberOfSimulations() {
        return this.numOfSim;
    }

    public int getVitalityCost() {
        return this.vitalityCost;
    }

    public int getTotalDrained() {
        return this.totalDrained;
    }

    public float getETA() {
        return (float)(((double)(this.vitalityCost - this.totalDrained) - this.accumulator) / (this.perTickRatio * 20.0));
    }

    public float getRate() {
        return (float)this.perTickRatio;
    }

    public boolean setActive(int rate, int cost, int numOfSim) {
        if (this.isDisabled()) {
            return false;
        }
        this.perTickRatio = (double)cost / (double)rate;
        this.accumulator = 0.0;
        this.vitalityCost = cost;
        this.totalDrained = 0;
        this.numOfSim = numOfSim;
        this.m_6596_();
        return true;
    }

    public boolean isActive() {
        return this.totalDrained < this.vitalityCost;
    }

    public boolean tick(WootFluidTankHandler tank) {
        if (this.getMob() == null || this.getMob().isBlacklisted() || !this.isActive()) {
            return false;
        }
        if (this.redstoneMode != RedstoneMode.ONCE && this.isDisabled()) {
            return false;
        }
        this.accumulator += this.perTickRatio;
        int drainAmount = (int)this.accumulator;
        this.accumulator -= (double)drainAmount;
        if (drainAmount <= 0) {
            return false;
        }
        FluidStack simulate = tank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
        if (simulate.getAmount() < drainAmount) {
            this.accumulator += (double)drainAmount - this.perTickRatio;
            this.m_6596_();
            return false;
        }
        FluidStack consumed = tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
        this.totalDrained += consumed.getAmount();
        if (this.totalDrained >= this.vitalityCost) {
            this.vitalityCost = 0;
            this.totalDrained = 0;
            this.m_6596_();
            return true;
        }
        this.m_6596_();
        return false;
    }

    public Tier getTier() {
        if (this.mobTag == null) {
            return Tier.INVALID;
        }
        if (!WootFactoryMobsRegistry.hasFactoryMob(this.mobTag)) {
            return Tier.INVALID;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
        return mob.getTier();
    }

    public static ItemStack getItemStack(CompoundTag tag) {
        ItemStack itemStack = ((Block)BlocksRegistry.FAKE_SPAWNER_BLOCK.get()).m_5456_().m_7968_();
        CompoundTag blockTag = itemStack.m_41698_("BlockEntityTag");
        blockTag.m_128365_("Mob", (Tag)tag);
        return itemStack;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
    }

    protected boolean isDisabled() {
        if (this.redstoneMode == RedstoneMode.ALWAYS_ON) {
            return false;
        }
        boolean current = this.f_58857_.m_276867_(this.m_58899_());
        if (this.redstoneMode != RedstoneMode.ONCE) {
            return this.redstoneMode == RedstoneMode.WITH_SIGNAL != current;
        }
        boolean risingEdge = !this.lastRedstoneState && current;
        this.lastRedstoneState = current;
        return !risingEdge;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("RedstoneMode", this.redstoneMode.ordinal());
        CompoundTag mobTag = this.getMobTag();
        if (mobTag != null) {
            tag.m_128365_("Mob", (Tag)mobTag);
        }
        tag.m_128405_("NumOfSim", this.numOfSim);
        tag.m_128405_("VitalityCost", this.vitalityCost);
        tag.m_128405_("TotalDrained", this.totalDrained);
        tag.m_128347_("PerTickRatio", this.perTickRatio);
        tag.m_128347_("Accumulator", this.accumulator);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.redstoneMode = RedstoneMode.byIndex(tag.m_128451_("RedstoneMode"));
        if (tag.m_128441_("Mob")) {
            this.mobTag = tag.m_128469_("Mob");
        }
        this.numOfSim = tag.m_128451_("NumOfSim");
        this.vitalityCost = tag.m_128451_("VitalityCost");
        this.totalDrained = tag.m_128451_("TotalDrained");
        this.perTickRatio = tag.m_128459_("PerTickRatio");
        this.accumulator = tag.m_128459_("Accumulator");
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void sendNewState() {
        NetworkChannel.channel.sendToServer((Object)new WootFakeSpawnerUpdate(this.m_58899_(), this.redstoneMode));
    }

    public void handleNewState(WootFakeSpawnerUpdate update) {
        if (update.redstoneMode() != null) {
            this.redstoneMode = update.redstoneMode();
        }
        this.m_6596_();
    }

    public boolean canPlayerAccess(ServerPlayer player) {
        return !(player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) > 64.0);
    }
}

