/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fake_spawner;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.blocks.factory.FactoryBlockItem;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.common.WootTier;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.render.WootStyles;

public class FakeSpawnerBlockItem
extends FactoryBlockItem {
    public FakeSpawnerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("Mob")) {
            WootFactoryMob<?> mob;
            CompoundTag mobTag = tag.m_128469_("Mob");
            if (level == null) {
                level = Minecraft.m_91087_().f_91073_;
            }
            if ((mob = WootFactoryMobsRegistry.getFactoryMob(mobTag)) != null) {
                tooltip.add((Component)mob.getDisplayName(mobTag, (HolderLookup.Provider)level.m_9598_()).m_6270_(WootStyles.CAPTURED_STYLE));
                String modId = ForgeRegistries.ENTITY_TYPES.getKey(mob.getEntityType()).m_135827_();
                tooltip.add((Component)ModNameHelper.getModName(modId).m_6270_(WootStyles.MOD_NAME_STYLE));
            }
            tooltip.add((Component)Component.m_237115_((String)"info.woot_revived.tier").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)WootTier.getTranslationKey(mob.getTier()))).m_6270_(WootStyles.DESCRIPTION_STYLE));
        }
    }

    protected boolean m_7274_(@NotNull BlockPos pos, @NotNull Level level, @Nullable Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        BlockEntity blockEntity;
        super.m_7274_(pos, level, player, stack, state);
        if (stack.m_41782_() && stack.m_41737_("BlockEntityTag") != null && (blockEntity = level.m_7702_(pos)) instanceof FakeSpawnerBlockEntity) {
            FakeSpawnerBlockEntity fakeSpawnerBlockEntity = (FakeSpawnerBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            fakeSpawnerBlockEntity.m_142466_(tag);
            fakeSpawnerBlockEntity.m_6596_();
        }
        return true;
    }
}

