/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fluid_infuser;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.fluid_infuser.FluidInfuserContainerMenu;
import wootrevived.woot.config.FluidInfuserConfig;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.recipes.WootContainer;

public class FluidInfuserBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<Map<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<Map<MachineSide, MachineSideProperty>>(3);
    public static final int INPUT_FLUID_PROPERTY = 0;
    public static final int OUTPUT_FLUID_PROPERTY = 1;
    public static final int INGREDIENT_PROPERTY = 2;
    public final WootItemStackHandler inventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            FluidInfuserBlockEntity.this.onContentsChanged(slot);
            FluidInfuserBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return FluidInfuserRecipe.Validator.isCatalystValid(stack);
        }
    };
    public static final int INPUT_SLOT = 0;
    private FluidInfuserRecipe recipe = null;

    public FluidInfuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FLUID_INFUSER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 3; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof FluidInfuserBlockEntity) {
            FluidInfuserBlockEntity fluidInfuserBlockEntity = (FluidInfuserBlockEntity)blockEntity;
            fluidInfuserBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    @Override
    public void m_155252_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.m_155252_(level, pos, state, blockEntity);
        if (level.f_46443_) {
            return;
        }
        this.tickFluid(this.inputTankHandler, pos, (Integer)FluidInfuserConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getInputFluidProperty());
        this.tickFluid(this.outputTankHandler, pos, (Integer)FluidInfuserConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        Properties properties = this.getProperties(side);
        if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            WootItemHandlerWrapper wrapper = new WootItemHandlerWrapper().addHandler(this.inventoryHandler, properties::getIngredientProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            WootFluidHandlerWrapper wrapper = new WootFluidHandlerWrapper().addHandler(this.outputTankHandler, properties::getOutputFluidProperty).addHandler(this.inputTankHandler, properties::getInputFluidProperty);
            return LazyOptional.of(() -> wrapper).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("InputInventory")) {
            this.inventoryHandler.deserializeNBT(tag.m_128469_("InputInventory"));
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InputInventory", (Tag)this.inventoryHandler.serializeNBT());
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(0);
        if (!itemStack.m_41619_()) {
            drops.add(itemStack);
            this.inventoryHandler.insertItem(0, ItemStack.f_41583_, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.woot_revived.fluid_infuser.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new FluidInfuserContainerMenu(containerId, this.f_58857_, this.m_58899_(), playerInventory, player);
    }

    @Override
    public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
        this.recipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.recipe != null ? this.recipe.getEnergy() : 0;
    }

    @Override
    protected void processFinished() {
        if (this.recipe == null) {
            this.getRecipe();
        }
        if (this.recipe == null) {
            this.processOff();
            return;
        }
        FluidInfuserRecipe recipe = this.recipe;
        ItemStack item = this.inventoryHandler.getStackInSlot(0);
        if (item.m_41720_().hasCraftingRemainingItem(item)) {
            this.inventoryHandler.setStackInSlot(0, item.m_41720_().getCraftingRemainingItem(item));
        } else {
            int ingredientAmount = recipe.ingredientCount(this.inventoryHandler.getStackInSlot(0).m_41720_());
            this.inventoryHandler.extractItem(0, ingredientAmount, false);
        }
        this.inputTankHandler.drain(recipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.outputTankHandler.fill(new FluidStack(recipe.getOutputFluid(), recipe.getOutputFluid().getAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.m_6596_();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.recipe == null) {
            return false;
        }
        if (!this.outputTankHandler.isEmpty() && this.outputTankHandler.getFluid().getFluid() != this.recipe.getOutputFluid().getFluid()) {
            return false;
        }
        if (this.outputTankHandler.getFluidAmount() + this.recipe.getOutputFluid().getAmount() > this.outputTankHandler.getCapacity()) {
            return false;
        }
        return this.inputTankHandler.getFluid().getAmount() >= this.recipe.getInputFluid().getAmount();
    }

    private void getRecipe() {
        this.clearRecipe();
        FluidStack inFluid = this.inputTankHandler.getFluid();
        if (inFluid.isEmpty()) {
            this.clearRecipe();
            return;
        }
        ItemStack catalyst = this.inventoryHandler.getStackInSlot(0);
        if (catalyst.m_41619_()) {
            this.clearRecipe();
            return;
        }
        this.recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.FLUID_INFUSER_RECIPE_TYPE.get(), (Container)new WootContainer(Either.right((Object)this.inputTankHandler.getFluid()), Either.left((Object)this.inventoryHandler.getStackInSlot(0))), this.f_58857_).orElse(null);
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)FluidInfuserConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)FluidInfuserConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return (Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasInputFluidCapability() {
        return true;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return FluidInfuserRecipe.Validator::isFluidValid;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(FluidInfuserBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(2).get((Object)this.machineSide);
        }

        public MachineSideProperty getInputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }
    }
}

