/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.heart;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.heart.HeartBlockEntity;
import wootrevived.woot.multiblock.MultiBlockFactory;
import wootrevived.woot.util.render.WootShapes;

public class HeartBlock
extends MultiBlockFactory {
    protected StateDefinition<Block, BlockState> heartStateDefinition;

    public HeartBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.heartStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return HeartBlockEntity::ticker;
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.heartStateDefinition;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61431_});
    }

    public static class State
    extends MultiBlockFactory.State {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity = level.m_7702_(hit.m_82425_());
            if (!(blockEntity instanceof HeartBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            HeartBlockEntity heart = (HeartBlockEntity)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)heart, (BlockPos)hit.m_82425_());
            return InteractionResult.SUCCESS;
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @NotNull
        public BlockState m_60715_(Mirror mirror) {
            return this.rotate(null, null, mirror.m_54846_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @Override
        @NotNull
        public VoxelShape m_60651_(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            if (!((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return WootShapes.disabledShape;
            }
            return Shapes.m_83144_();
        }

        @Override
        @NotNull
        public RenderShape m_60799_() {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                return RenderShape.MODEL;
            }
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        @Override
        public void m_60696_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                super.m_60696_(level, pos, newState, isMoving);
            }
        }

        @Override
        public void m_60753_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            if (((Boolean)this.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                super.m_60753_(level, pos, newState, isMoving);
            }
        }
    }
}

