/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.heart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.woot.blocks.cell.CellBlockEntity;
import wootrevived.woot.blocks.factory_upgrade.FactoryUpgradeBlockEntity;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.blocks.ingredient_import.IngredientImportBlockEntity;
import wootrevived.woot.client.render.heart.HeartContainerMenu;
import wootrevived.woot.drops.simulator.DropSimulator;
import wootrevived.woot.multiblock.MultiBlockFactoryEntity;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Patterns;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.factory.WootConcatFluidStack;
import wootrevived.woot.util.factory.WootConcatItemStack;
import wootrevived.woot.util.factory.WootFactoryDropsProperties;
import wootrevived.woot.util.factory.WootFactoryGenerationProperties;
import wootrevived.woot.util.factory.WootFactorySpawnProperties;

public class HeartBlockEntity
extends MultiBlockFactoryEntity
implements MenuProvider {
    private final List<BlockPos> fakeSpawnersPos = new ArrayList<BlockPos>(4);
    private final List<BlockPos> upgradesPos = new ArrayList<BlockPos>(4);
    private final BlockPos importPos;
    private final BlockPos exportPos;
    private final BlockPos cellPos;
    private FakeSpawnerBlockEntity primaryFakeSpawner;
    private final FakeSpawnerBlockEntity[] secondaryFakeSpawners = new FakeSpawnerBlockEntity[3];
    private final FactoryUpgradeBlockEntity[] upgrades = new FactoryUpgradeBlockEntity[4];
    private CellBlockEntity cell;
    private IngredientImportBlockEntity ingredientImport;

    public HeartBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.HEART_BLOCK_ENTITY.get(), pos, state);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        for (Pattern.PatternBlock block : Patterns.getFakeSpawnersBlocks(facing)) {
            this.fakeSpawnersPos.add(block.getLevelBlockPos(pos));
        }
        for (Pattern.PatternBlock block : Patterns.getUpgradeBlocks(facing)) {
            this.upgradesPos.add(block.getLevelBlockPos(pos));
        }
        this.importPos = Patterns.getImportBlock(facing).getLevelBlockPos(pos);
        this.exportPos = Patterns.getExportBlock(facing).getLevelBlockPos(pos);
        this.cellPos = Patterns.getCellBlock(facing).getLevelBlockPos(pos);
    }

    public FakeSpawnerBlockEntity getPrimaryFakeSpawner() {
        return this.primaryFakeSpawner;
    }

    public FakeSpawnerBlockEntity getSecondaryFakeSpawner(int index) {
        return this.secondaryFakeSpawners[index];
    }

    public FactoryUpgradeBlockEntity getUpgrade(int index) {
        return this.upgrades[index];
    }

    public CellBlockEntity getCell() {
        return this.cell;
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof HeartBlockEntity) {
            HeartBlockEntity heartBlockEntity = (HeartBlockEntity)blockEntity;
            heartBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    public void m_155252_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        int i;
        if (!((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            return;
        }
        if (this.tier == Tier.INVALID) {
            this.resetFactory();
            return;
        }
        this.primaryFakeSpawner = this.getBlockEntity(this.primaryFakeSpawner, this.fakeSpawnersPos.get(0), FakeSpawnerBlockEntity.class);
        if (this.primaryFakeSpawner == null) {
            this.resetFactory();
            return;
        }
        this.primaryFakeSpawner.index = 0;
        this.cell = this.getBlockEntity(this.cell, this.cellPos, CellBlockEntity.class);
        if (this.cell == null) {
            this.resetFactory();
            return;
        }
        this.ingredientImport = this.getBlockEntity(this.ingredientImport, this.importPos, IngredientImportBlockEntity.class);
        if (this.ingredientImport == null) {
            this.resetFactory();
            return;
        }
        if (this.tier != Tier.TIER_1) {
            for (i = 0; i < this.secondaryFakeSpawners.length; ++i) {
                this.secondaryFakeSpawners[i] = this.getBlockEntity(this.secondaryFakeSpawners[i], this.fakeSpawnersPos.get(1 + i), FakeSpawnerBlockEntity.class);
                if (this.secondaryFakeSpawners[i] == null) continue;
                this.secondaryFakeSpawners[i].index = 1 + i;
            }
        } else {
            Arrays.fill((Object[])this.secondaryFakeSpawners, null);
        }
        for (i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = this.tier == Tier.TIER_1 && i != 0 ? null : this.getBlockEntity(this.upgrades[i], this.upgradesPos.get(i), FactoryUpgradeBlockEntity.class);
        }
        if (level.f_46443_) {
            return;
        }
        ArrayList<FakeSpawnerBlockEntity> fakeSpawners = new ArrayList<FakeSpawnerBlockEntity>(1);
        fakeSpawners.add(this.primaryFakeSpawner);
        for (FakeSpawnerBlockEntity fakeSpawner : this.secondaryFakeSpawners) {
            if (fakeSpawner == null) continue;
            fakeSpawners.add(fakeSpawner);
        }
        for (FakeSpawnerBlockEntity fakeSpawner : fakeSpawners) {
            if (!this.isTierEntityValid(fakeSpawner)) continue;
            WootFactoryMob<?> mob = fakeSpawner.getMob();
            CompoundTag mobTag = fakeSpawner.getMobTag();
            List<ItemStack> importItemStacks = mob.getImportItems(mobTag, (HolderLookup.Provider)level.m_9598_());
            this.ingredientImport.setImportItem(fakeSpawner.index, importItemStacks.size() > 36 ? importItemStacks.subList(0, 36) : importItemStacks);
            List<FluidStack> importFluidStacks = mob.getImportFluids(mobTag, (HolderLookup.Provider)level.m_9598_());
            this.ingredientImport.setImportFluid(fakeSpawner.index, importFluidStacks.size() > 8 ? importFluidStacks.subList(0, 8) : importFluidStacks);
            this.ingredientImport.extractNeighbors();
            if (!fakeSpawner.isActive() && this.ingredientImport.isImportValid(fakeSpawner.index)) {
                WootGenerationProperties properties = this.getWootGenerationProperties(mob, mobTag);
                if (!fakeSpawner.setActive(properties.getSpawnRate(), properties.getVitalityFuelCost(), properties.getNumberOfSimulations())) continue;
                this.ingredientImport.consumeImports(fakeSpawner.index);
                continue;
            }
            if (!fakeSpawner.tick(this.cell.tankHandler)) continue;
            GenerationResult result = this.generateDrops(fakeSpawner);
            for (Direction direction : Direction.values()) {
                BlockPos blockPos;
                BlockEntity entity;
                if (direction == Direction.UP || direction == Direction.DOWN || (entity = level.m_7702_(blockPos = this.exportPos.m_121945_(direction))) == null) continue;
                entity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(handler -> {
                    for (ItemStack stack : List.copyOf(result.items)) {
                        ItemStack insert = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                        if (insert.m_41619_()) {
                            result.items.remove(stack);
                            continue;
                        }
                        if (insert.m_41613_() == stack.m_41613_()) continue;
                        stack.m_41764_(insert.m_41613_());
                    }
                });
                entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(handler -> {
                    for (FluidStack stack : List.copyOf(result.fluids)) {
                        int amount = handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                        if (stack.getAmount() == amount) {
                            result.fluids.remove(stack);
                            continue;
                        }
                        if (amount <= 0) continue;
                        stack.shrink(amount);
                    }
                });
            }
        }
    }

    @NotNull
    private WootGenerationProperties getWootGenerationProperties(WootFactoryMob<?> mob, CompoundTag mobTag) {
        WootFactoryGenerationProperties properties = new WootFactoryGenerationProperties(this.tier, mob, mobTag, (ServerLevel)this.f_58857_, this.m_58899_(), mob.getSpawnTickRate(), mob.getVitalityFuelCost());
        for (FactoryUpgradeBlockEntity upgradeBlockEntity : this.upgrades) {
            if (upgradeBlockEntity == null) continue;
            upgradeBlockEntity.applyGenerationProperties(properties);
        }
        return properties;
    }

    protected boolean isTierEntityValid(FakeSpawnerBlockEntity fakeSpawner) {
        if (fakeSpawner == null) {
            return false;
        }
        WootFactoryMob<?> mob = fakeSpawner.getMob();
        if (mob == null) {
            return false;
        }
        return this.tier.isMobTierValid(mob.getTier());
    }

    protected GenerationResult generateDrops(FakeSpawnerBlockEntity fakeSpawner) {
        WootFactoryMob<?> mob = fakeSpawner.getMob();
        CompoundTag mobTag = fakeSpawner.getMobTag();
        ArrayList<ItemStack> unconcatItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> unconcatFluids = new ArrayList<FluidStack>();
        for (int i = 0; i < fakeSpawner.getNumberOfSimulations(); ++i) {
            WootFactorySpawnProperties spawnProperties = new WootFactorySpawnProperties(this.tier, mob, mobTag, (ServerLevel)this.f_58857_, this.m_58899_());
            for (FactoryUpgradeBlockEntity upgradeBlockEntity : this.upgrades) {
                if (upgradeBlockEntity == null) continue;
                upgradeBlockEntity.applySpawnProperties(spawnProperties);
            }
            LivingEntity entity = DropSimulator.loadEntity(mob, spawnProperties.getFactoryMobTag());
            WootFactoryDropsProperties generationProperties = new WootFactoryDropsProperties(spawnProperties, entity);
            DropSimulator.patchDimension(generationProperties, false);
            if (!mob.isSimulationDisabled()) {
                DropSimulator.simulateDrops(generationProperties);
            }
            mob.modifyDrops(WootFactoryMob.Phase.BEFORE_DROP_CALLBACKS, generationProperties);
            if (WootFactoryMobsRegistry.hasDropsModifier(mob.getEntityType())) {
                for (Consumer<WootDropsProperties> callback : WootFactoryMobsRegistry.getDropsModifier(mob.getEntityType())) {
                    callback.accept(generationProperties);
                }
            }
            for (Consumer<WootDropsProperties> callback : WootFactoryMobsRegistry.getGlobalDropsModifier()) {
                callback.accept(generationProperties);
            }
            mob.modifyDrops(WootFactoryMob.Phase.AFTER_DROP_CALLBACKS, generationProperties);
            for (FactoryUpgradeBlockEntity upgradeBlockEntity : this.upgrades) {
                if (upgradeBlockEntity == null) continue;
                upgradeBlockEntity.modifyDrops(generationProperties);
            }
            mob.modifyDrops(WootFactoryMob.Phase.AFTER_UPGRADES, generationProperties);
            DropSimulator.patchDimension(generationProperties, true);
            unconcatItems.addAll(generationProperties.getItemDrops());
            unconcatFluids.addAll(generationProperties.getFluidDrops());
        }
        return new GenerationResult(WootConcatItemStack.merge(unconcatItems), WootConcatFluidStack.merge(unconcatFluids));
    }

    protected void resetFactory() {
        this.primaryFakeSpawner = null;
        Arrays.fill((Object[])this.secondaryFakeSpawners, null);
        Arrays.fill((Object[])this.upgrades, null);
        this.ingredientImport = null;
        this.cell = null;
    }

    @Nullable
    protected <T extends BlockEntity> T getBlockEntity(T oldEntity, BlockPos pos, Class<T> clazz) {
        if (oldEntity != null && !oldEntity.m_58901_()) {
            return oldEntity;
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (!clazz.isInstance(be)) {
            return null;
        }
        return (T)((BlockEntity)clazz.cast(be));
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.woot_revived.heart.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new HeartContainerMenu(containerId, this.f_58857_, this.m_58899_(), playerInventory, player);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
    }

    public static class GenerationResult {
        public List<ItemStack> items;
        public List<FluidStack> fluids;

        public GenerationResult(List<ItemStack> items, List<FluidStack> fluids) {
            this.items = items;
            this.fluids = fluids;
        }
    }
}

