/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.ingredient_import;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootImportFluidHandler;
import wootrevived.woot.util.handlers.WootImportItemHandler;

public class IngredientImportBlockEntity
extends FactoryBlockBaseEntity {
    private final WootImportItemHandler itemHandler = new WootImportItemHandler();
    private final LazyOptional<IItemHandler> item = LazyOptional.of(() -> this.itemHandler);
    private final WootImportFluidHandler fluidHandler = new WootImportFluidHandler();
    private final LazyOptional<IFluidHandler> fluid = LazyOptional.of(() -> this.fluidHandler);

    public IngredientImportBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.IMPORT_BLOCK_ENTITY.get(), pos, state);
    }

    public void setImportItem(int index, List<ItemStack> importItem) {
        this.itemHandler.setImportItem(index, importItem);
    }

    public void setImportFluid(int index, List<FluidStack> importFluid) {
        this.fluidHandler.setImportFluid(index, importFluid);
    }

    public boolean isImportValid(int index) {
        return this.itemHandler.isImportValid(index) && this.fluidHandler.isImportValid(index);
    }

    public void consumeImports(int index) {
        this.itemHandler.consume(index);
        this.fluidHandler.consume(index);
    }

    public void extractNeighbors() {
        for (Direction direction : Direction.values()) {
            BlockPos blockPos;
            BlockEntity entity;
            if (direction == Direction.UP || direction == Direction.DOWN || (entity = this.f_58857_.m_7702_(blockPos = this.m_58899_().m_121945_(direction))) == null) continue;
            entity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack extracted;
                    ItemStack stack = handler.getStackInSlot(i);
                    ItemStack result = this.itemHandler.insertItem(i, stack, true);
                    if (result.m_41613_() >= stack.m_41613_() || (extracted = handler.extractItem(i, stack.m_41613_() - result.m_41613_(), false)).m_41619_()) continue;
                    this.itemHandler.insertItem(i, extracted, false);
                }
            });
            entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(handler -> {
                for (int i = 0; i < handler.getTanks(); ++i) {
                    FluidStack drained;
                    FluidStack stack = handler.getFluidInTank(i);
                    int filled = this.fluidHandler.fill(stack, IFluidHandler.FluidAction.SIMULATE);
                    if (filled <= 0 || (drained = handler.drain(new FluidStack(stack.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
                    this.fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            return LazyOptional.empty();
        }
        if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            return this.fluid.cast();
        }
        if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            return this.item.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.itemHandler.save(tag);
        this.fluidHandler.save(tag);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.load(tag);
        this.fluidHandler.load(tag);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

