/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.item_infuser;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.item_infuser.ItemInfuserBlockEntity;
import wootrevived.woot.config.ItemInfuserConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class ItemInfuserBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> itemInfuserStateDefinition;

    public ItemInfuserBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.itemInfuserStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.itemInfuserStateDefinition;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.ITEM_INFUSER_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return blockEntityType == BlocksRegistry.ITEM_INFUSER_BLOCK_ENTITY.get() ? ItemInfuserBlockEntity::ticker : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter block, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_5871_(stack, block, tooltip, flag);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("Energy")) {
            CompoundTag energyTag = tag.m_128469_("Energy");
            tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.power").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)Component.m_237113_((String)WootContainerScreen.formatInteger(energyTag.m_128451_("Energy")))).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger((Integer)ItemInfuserConfig.ENERGY_CAPACITY.get())).m_7220_((Component)Component.m_237113_((String)" FE").m_6270_(WootStyles.UNIT_STYLE)));
        }
        if (tag.m_128441_("InputTank")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("InputTank"));
            tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.input_fluid").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.m_237115_((String)"info.woot_revived.empty"))));
            tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.input_amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger((Integer)ItemInfuserConfig.INPUT_TANK_CAPACITY.get())).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
        }
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(hit.m_82425_());
            if (!(blockEntity instanceof ItemInfuserBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            ItemInfuserBlockEntity itemInfuserBlockEntity = (ItemInfuserBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.m_82425_(), (Direction)hit.m_82434_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)itemInfuserBlockEntity, (BlockPos)hit.m_82425_());
            return InteractionResult.SUCCESS;
        }

        public void m_60753_(@NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
            if (this.m_60734_() != newState.m_60734_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ItemInfuserBlockEntity) {
                    ItemInfuserBlockEntity itemInfuserBlockEntity = (ItemInfuserBlockEntity)blockEntity;
                    itemInfuserBlockEntity.dropContents(level, pos);
                }
                super.m_60753_(level, pos, newState, isMoving);
            }
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @NotNull
        public BlockState m_60715_(Mirror mirror) {
            return this.rotate(null, null, mirror.m_54846_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
    }
}

