/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.layout;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.layout.LayoutBlockEntity;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Patterns;
import wootrevived.woot.registries.BlocksRegistry;

public class LayoutBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> layoutStateDefinition;

    public LayoutBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.layoutStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.layoutStateDefinition;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.LAYOUT_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return LayoutBlockEntity::ticker;
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @NotNull
        public BlockState m_60715_(Mirror mirror) {
            return this.rotate(null, null, mirror.m_54846_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.f_46443_ || hand == InteractionHand.OFF_HAND) {
                return super.m_60664_(level, player, hand, hit);
            }
            if (!player.m_21205_().m_41619_()) {
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.m_7702_(hit.m_82425_());
            if (blockEntity instanceof LayoutBlockEntity) {
                LayoutBlockEntity layoutBlockEntity = (LayoutBlockEntity)blockEntity;
                layoutBlockEntity.setNextTier();
            }
            return InteractionResult.SUCCESS;
        }

        public void m_60753_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
            if (!level.f_46443_) {
                Direction facing = (Direction)this.m_61143_((Property)BlockStateProperties.f_61374_);
                BlockPos layoutPos = switch (facing) {
                    case Direction.NORTH -> pos.m_7918_(0, 10, -1);
                    case Direction.SOUTH -> pos.m_7918_(0, 10, 1);
                    case Direction.EAST -> pos.m_7918_(1, 10, 0);
                    case Direction.WEST -> pos.m_7918_(-1, 10, 0);
                    default -> pos;
                };
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_1.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_2.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_3.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_4.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_5.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
            }
            super.m_60753_(level, pos, newState, movedByPiston);
        }
    }
}

