/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.layout;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.enums.Tier;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Patterns;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBase;
import wootrevived.woot.util.common.WootTier;

public class LayoutBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    private int blockRenderOffset = 0;
    private static final int TICK_DELAY = 20;
    private int delayTick = 20;
    private Tier tier = Tier.TIER_1;
    static final String KEY_TIER = "tier";

    public LayoutBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.LAYOUT_BLOCK_ENTITY.get(), pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof LayoutBlockEntity) {
            LayoutBlockEntity layoutBlockEntity = (LayoutBlockEntity)blockEntity;
            layoutBlockEntity.m_155252_(level, pos, state, blockEntity);
        }
    }

    public int getBlockRenderOffset() {
        return this.blockRenderOffset;
    }

    public void m_155252_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        int height = Patterns.getHeight();
        BlockPos layoutPos = switch (facing) {
            case Direction.NORTH -> this.m_58899_().m_7918_(0, height, -1);
            case Direction.SOUTH -> this.m_58899_().m_7918_(0, height, 1);
            case Direction.EAST -> this.m_58899_().m_7918_(1, height, 0);
            case Direction.WEST -> this.m_58899_().m_7918_(-1, height, 0);
            default -> this.m_58899_();
        };
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_1.patterns.get(facing)) {
            if (Tier.TIER_1.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_2.patterns.get(facing)) {
            if (Tier.TIER_2.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_3.patterns.get(facing)) {
            if (Tier.TIER_3.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_4.patterns.get(facing)) {
            if (Tier.TIER_4.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        for (Pattern.PatternBlock patternBlock : Patterns.TIER_5.patterns.get(facing)) {
            if (Tier.TIER_5.isFactoryTierValid(this.tier)) {
                LayoutBlockEntity.placePatternBlock(level, facing, layoutPos, patternBlock, this.getBlockRenderOffset());
                continue;
            }
            LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
        }
        if (this.delayTick-- != 0) {
            return;
        }
        this.delayTick = 20;
        ++this.blockRenderOffset;
    }

    public static void placePatternBlock(@NotNull Level level, Direction facing, BlockPos layoutPos, Pattern.PatternBlock patternBlock, int blockRenderOffset) {
        BlockPos blockPos;
        BlockState state;
        Block block = patternBlock.blocks[blockRenderOffset % (int)Arrays.stream(patternBlock.blocks).count()];
        BlockState blockState = (BlockState)block.m_49965_().m_61090_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61431_)) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(false));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        }
        if ((state = level.m_8055_(blockPos = patternBlock.getLevelBlockPos(layoutPos))).m_60734_() == Blocks.f_50016_) {
            level.m_7731_(blockPos, blockState, 3);
        } else if (state.m_60734_() instanceof FactoryBlockBase && state.m_60734_() != block && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            level.m_7731_(blockPos, blockState, 3);
        }
    }

    public static void removePatternBlock(@NotNull Level level, BlockPos layoutPos, Pattern.PatternBlock patternBlock) {
        for (Block block : patternBlock.blocks) {
            BlockPos blockPos = patternBlock.getLevelBlockPos(layoutPos);
            BlockState s = level.m_8055_(blockPos);
            if (!(s.m_60734_() instanceof FactoryBlockBase) || s.m_60734_() != block || ((Boolean)s.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) continue;
            level.m_7471_(blockPos, false);
        }
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setNextTier() {
        this.tier = WootTier.getNextValid(this.tier);
        this.m_6596_();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(KEY_TIER, this.tier.ordinal());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(KEY_TIER)) {
            this.tier = WootTier.byIndex(tag.m_128451_(KEY_TIER));
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

