/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.stygian_anvil;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.stygian_anvil.StygianAnvilBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ItemsRegistry;

public class StygianAnvilBlock
extends Block
implements EntityBlock {
    private static final VoxelShape PART_BASE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PART_LOWER_X = Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape PART_MID_X = Block.m_49796_((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PART_UPPER_X = Block.m_49796_((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape PART_LOWER_Z = Block.m_49796_((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape PART_MID_Z = Block.m_49796_((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PART_UPPER_Z = Block.m_49796_((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.m_83124_((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_X, PART_MID_X, PART_UPPER_X});
    private static final VoxelShape Z_AXIS_AABB = Shapes.m_83124_((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_Z, PART_MID_Z, PART_UPPER_Z});
    protected StateDefinition<Block, BlockState> anvilStateDefinition;

    public StygianAnvilBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.anvilStateDefinition = stateDefinitionBuilder.m_61101_(Block::m_49966_, State::new);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> m_49965_() {
        return this.anvilStateDefinition;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122427_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public boolean isAnvilHot(Level level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50450_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() != ParticleStatus.MINIMAL && random.m_188503_(10) == 0 && this.isAnvilHot(level, pos)) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.STYGIAN_ANVIL_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    public static class State
    extends BlockState {
        public State(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public InteractionResult m_60664_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            BlockEntity be;
            if (level.f_46443_) {
                super.m_60664_(level, player, hand, hit);
            }
            if ((be = level.m_7702_(hit.m_82425_())) instanceof StygianAnvilBlockEntity) {
                StygianAnvilBlockEntity anvil = (StygianAnvilBlockEntity)be;
                ItemStack heldItem = player.m_21120_(hand);
                if (player.m_6144_() && heldItem.m_41619_()) {
                    anvil.dropItem(player, hand);
                } else if (heldItem.m_41720_() == ItemsRegistry.STYGIAN_HAMMER_ITEM.get()) {
                    anvil.tryCraft(player);
                } else {
                    IItemHandler itemHandler = anvil.getInventory();
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        if (!itemHandler.getStackInSlot(slot).m_41619_()) continue;
                        ItemStack item = heldItem.m_41777_();
                        item.m_41764_(1);
                        ItemStack result = itemHandler.insertItem(slot, item, false);
                        if (result.equals(item)) break;
                        heldItem.m_41774_(1);
                        if (heldItem.m_41619_()) {
                            player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                        } else {
                            player.m_150109_().m_6836_(player.m_150109_().f_35977_, heldItem);
                        }
                        player.f_36096_.m_38946_();
                        break;
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }

        @NotNull
        public VoxelShape m_60651_(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            Direction direction = (Direction)this.m_61143_((Property)BlockStateProperties.f_61374_);
            return direction.m_122434_() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
        }

        public void m_60753_(@NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
            if (this.m_60734_() != newState.m_60734_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof StygianAnvilBlockEntity) {
                    StygianAnvilBlockEntity stygianAnvilBlockEntity = (StygianAnvilBlockEntity)blockEntity;
                    stygianAnvilBlockEntity.dropContents(level, pos);
                }
                super.m_60753_(level, pos, newState, isMoving);
            }
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }

        @NotNull
        public BlockState m_60715_(Mirror mirror) {
            return this.rotate(null, null, mirror.m_54846_((Direction)this.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
    }
}

