/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.stygian_anvil;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.blocks.stygian_anvil.StygianAnvilBlock;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class StygianAnvilBlockEntity
extends BlockEntity {
    public final ItemStackHandler inventoryHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            StygianAnvilBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == BASE_SLOT) {
                if (stack.m_41720_() instanceof MobShardItem) {
                    return MobShardItem.isFullyProgrammed(stack);
                }
                return StygianAnvilRecipe.Validator.isBaseValid(stack);
            }
            return StygianAnvilRecipe.Validator.isIngredientValid(stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public static int BASE_SLOT = 0;
    public static int INGREDIENT_1_SLOT = 1;
    public static int INGREDIENT_2_SLOT = 2;
    public static int INGREDIENT_3_SLOT = 3;
    public static int INGREDIENT_4_SLOT = 4;
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.inventoryHandler);

    public StygianAnvilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.STYGIAN_ANVIL_BLOCK_ENTITY.get(), pos, state);
    }

    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            return this.inventory.cast();
        }
        return LazyOptional.empty();
    }

    public ItemStack[] getIngredients() {
        return new ItemStack[]{this.inventoryHandler.getStackInSlot(INGREDIENT_1_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_2_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_3_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_4_SLOT)};
    }

    public void dropContents(Level level, BlockPos pos) {
        for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
            ItemStack stack = this.inventoryHandler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        this.m_6596_();
    }

    public void dropItem(Player player, InteractionHand hand) {
        ItemStack itemStack = ItemStack.f_41583_;
        for (int slot = this.inventoryHandler.getSlots() - 1; slot >= 0; --slot) {
            ItemStack stack = this.inventoryHandler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            itemStack = stack;
            this.inventoryHandler.setStackInSlot(slot, ItemStack.f_41583_);
            break;
        }
        if (!itemStack.m_41619_()) {
            this.m_6596_();
            player.m_21008_(hand, itemStack);
        }
    }

    public void tryCraft(Player playerEntity) {
        if (!((StygianAnvilBlock)((Object)BlocksRegistry.STYGIAN_ANVIL_BLOCK.get())).isAnvilHot(this.f_58857_, this.m_58899_())) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"chat.woot_revived.anvil.cold"), true);
            return;
        }
        StygianAnvilRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.ANVIL_RECIPE_TYPE.get(), (Container)new WootContainer(Either.left((Object)this.inventoryHandler.getStackInSlot(BASE_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_1_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_2_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_3_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_4_SLOT))), this.f_58857_).orElse(null);
        if (recipe == null) {
            return;
        }
        ItemStack output = recipe.getOutput();
        ItemStack baseStack = this.inventoryHandler.getStackInSlot(BASE_SLOT);
        if (baseStack.m_41720_() instanceof MobShardItem) {
            if (!MobShardItem.isFullyProgrammed(baseStack)) {
                return;
            }
            CompoundTag mobTag = MobShardItem.getProgrammedMob(baseStack);
            if (mobTag == null) {
                return;
            }
            output = FakeSpawnerBlockEntity.getItemStack(mobTag);
        }
        for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
            ItemStack item = this.inventoryHandler.getStackInSlot(slot);
            if (item.m_41720_().hasCraftingRemainingItem(item)) {
                this.inventoryHandler.setStackInSlot(slot, item.m_41720_().getCraftingRemainingItem(item));
                continue;
            }
            this.inventoryHandler.setStackInSlot(slot, ItemStack.f_41583_);
        }
        this.m_6596_();
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_(), output);
        itemEntity.m_32060_();
        this.f_58857_.m_7967_((Entity)itemEntity);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InputInventory", (Tag)this.inventoryHandler.serializeNBT());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("InputInventory")) {
            this.inventoryHandler.deserializeNBT(tag.m_128469_("InputInventory"));
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

