/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.enchanted_liquifier;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.blocks.enchanted_liquifier.EnchantedLiquifierBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.helper.EnchantmentHelper;
import wootrevived.woot.util.render.WootContainerMenu;
import wootrevived.woot.util.render.WootSlot;

public class EnchantedLiquifierContainerMenu
extends WootContainerMenu {
    private final Level level;
    public EnchantedLiquifierBlockEntity blockEntity;

    public EnchantedLiquifierContainerMenu(int id, Level level, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK_MENU.get(), id);
        this.level = level;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof EnchantedLiquifierBlockEntity)) {
            return;
        }
        EnchantedLiquifierBlockEntity be = (EnchantedLiquifierBlockEntity)blockEntity;
        this.blockEntity = be;
        this.data = be.data;
        this.createMachineInputSlots(be.getInventory());
        this.createPlayerInventory(playerInventory);
    }

    public EnchantedLiquifierContainerMenu(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv.f_35978_.m_9236_(), data.m_130135_(), inv, inv.f_35978_);
    }

    private void createMachineInputSlots(IItemHandler machineInventory) {
        this.m_38897_((Slot)new SlotItemHandler(machineInventory, 0, 80, 40));
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 160));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new WootSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack stackCopy = stack.m_41777_();
        boolean MACHINE_INV_SIZE = true;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 1) {
            if (EnchantmentHelper.isEnchanted(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (index < 28) {
                startIndex = 28;
                endIndex = startIndex + 9;
            } else {
                startIndex = 1;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 1;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.m_38903_(stack, startIndex, endIndex, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() == 0) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == stackCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return stackCopy;
    }

    public boolean m_6875_(@NotNull Player player) {
        return EnchantedLiquifierContainerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK.get()));
    }
}

