/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.heart;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.Woot;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.client.render.heart.HeartContainerMenu;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.common.WootTier;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootEntityRenderer;
import wootrevived.woot.util.render.WootSlot;
import wootrevived.woot.util.render.WootSlotItemHandler;
import wootrevived.woot.util.render.WootStyles;
import wootrevived.woot.util.render.buttons.WootHeartInputButton;
import wootrevived.woot.util.render.buttons.WootRedstoneButton;

@OnlyIn(value=Dist.CLIENT)
public class HeartContainerScreen
extends AbstractContainerScreen<HeartContainerMenu> {
    public static final ResourceLocation GUI = Woot.location("textures/gui/atlas.png");
    public static final int GUI_XSIZE = 176;
    public static final int GUI_YSIZE = 184;
    public static final int CELL_TANK_X = 148;
    public static final int CELL_TANK_Y = 57;
    public static final int PRIMARY_MOB_X = 8;
    public static final int PRIMARY_MOB_Y = 17;
    public static final int SECONDARY_MOB_0_X = 130;
    public static final int SECONDARY_MOB_0_Y = 17;
    public static final int SECONDARY_MOB_1_X = 90;
    public static final int SECONDARY_MOB_1_Y = 17;
    public static final int SECONDARY_MOB_2_X = 50;
    public static final int SECONDARY_MOB_2_Y = 17;
    private static double BOX_SIZE = 32.0;
    private static double BOX_PADDING = 3.0;
    private static float MAX_ENTITY_BOX_SIZE = 20.0f;
    public static final int UPGRADE_SLOT_0_X = 10;
    public static final int UPGRADE_SLOT_0_Y = 77;
    public static final int UPGRADE_SLOT_1_X = 28;
    public static final int UPGRADE_SLOT_1_Y = 77;
    public static final int UPGRADE_SLOT_2_X = 46;
    public static final int UPGRADE_SLOT_2_Y = 77;
    public static final int UPGRADE_SLOT_3_X = 64;
    public static final int UPGRADE_SLOT_3_Y = 77;
    public static final int UPGRADE_SLOT_TEXT_X = 10;
    public static final int UPGRADE_SLOT_TEXT_Y = 67;
    private final List<WootHeartInputButton> buttons = new ArrayList<WootHeartInputButton>();
    private int activeButton = -1;
    private WootRedstoneButton redstoneButton;

    public HeartContainerScreen(HeartContainerMenu container, Inventory playerInventory, Component name) {
        super((AbstractContainerMenu)container, playerInventory, name);
        this.f_97726_ = 176;
        this.f_97727_ = 184;
    }

    protected void renderMenuBackground(GuiGraphics gui) {
        this.renderEntityBoxBg(gui, 8, 17);
        this.renderEntityBoxBg(gui, 130, 17);
        this.renderEntityBoxBg(gui, 90, 17);
        this.renderEntityBoxBg(gui, 50, 17);
        this.renderFluidBg(gui, 148, 57);
        WootContainerScreen.renderVanillaSlot(gui, 10, 77);
        WootContainerScreen.renderVanillaSlot(gui, 28, 77);
        WootContainerScreen.renderVanillaSlot(gui, 46, 77);
        WootContainerScreen.renderVanillaSlot(gui, 64, 77);
        gui.m_280056_(this.f_96547_, "Upgrades:", 10, 67, 0x404040, false);
    }

    protected void renderState(GuiGraphics gui) {
        this.renderEntityBox(gui, 8, 17, this.getLivingEntity(0));
        this.renderEntityBox(gui, 130, 17, this.getLivingEntity(1));
        this.renderEntityBox(gui, 90, 17, this.getLivingEntity(2));
        this.renderEntityBox(gui, 50, 17, this.getLivingEntity(3));
        this.renderFluid(gui, 148, 57, ((HeartContainerMenu)this.f_97732_).getCellFluid(), ((HeartContainerMenu)this.f_97732_).getCellFluidCapacity());
        ((HeartContainerMenu)this.f_97732_).updateUpgrades();
        this.updateButton(0);
        this.updateButton(1);
        this.updateButton(2);
        this.updateButton(3);
    }

    protected void m_280072_(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        this.renderEntityTooltip(gui, mouseX, mouseY, 8, 17, 0);
        this.renderEntityTooltip(gui, mouseX, mouseY, 130, 17, 1);
        this.renderEntityTooltip(gui, mouseX, mouseY, 90, 17, 2);
        this.renderEntityTooltip(gui, mouseX, mouseY, 50, 17, 3);
        if (this.activeButton == -1) {
            this.renderFluidTooltip(gui, mouseX, mouseY, 148, 57, ((HeartContainerMenu)this.f_97732_).getCellFluid(), ((HeartContainerMenu)this.f_97732_).getCellFluidCapacity());
        } else {
            List<FluidStack> stacks = ((HeartContainerMenu)this.f_97732_).getFactoryMob(this.activeButton).getImportFluids(((HeartContainerMenu)this.f_97732_).getFactoryMobTag(this.activeButton), (HolderLookup.Provider)((HeartContainerMenu)this.f_97732_).getLevel().m_9598_());
            for (int i = 0; i < 8; ++i) {
                this.renderSmallFluidTooltip(gui, mouseX, mouseY, 9 + i * 20, 73, i >= stacks.size() ? FluidStack.EMPTY : stacks.get(i));
            }
        }
    }

    public void addRenderableWidget(WootHeartInputButton button) {
        this.buttons.add(button);
        this.m_7787_((GuiEventListener)button);
    }

    protected void renderFakeSpawner(GuiGraphics gui) {
        gui.m_280509_(4, 56, 172, 159, -3750202);
        gui.m_280218_(GUI, 7, 105, 7, 101, 162, 54);
        for (int i = 0; i < 8; ++i) {
            gui.m_280218_(GUI, 9 + i * 20, 73, 58, 185, 18, 19);
        }
        gui.m_280056_(this.f_96547_, "Needed Fluid Imports", 9, 63, 0x404040, false);
        gui.m_280056_(this.f_96547_, "Needed Item Imports", 7, 95, 0x404040, false);
        WootFactoryMob<?> mob = ((HeartContainerMenu)this.f_97732_).getFactoryMob(this.activeButton);
        CompoundTag tag = ((HeartContainerMenu)this.f_97732_).getFactoryMobTag(this.activeButton);
        ((HeartContainerMenu)this.f_97732_).updateImports(mob.getImportItems(tag, (HolderLookup.Provider)((HeartContainerMenu)this.f_97732_).getLevel().m_9598_()));
        List<FluidStack> stacks = mob.getImportFluids(tag, (HolderLookup.Provider)((HeartContainerMenu)this.f_97732_).getLevel().m_9598_());
        for (int i = 0; i < 8; ++i) {
            this.renderSmallFluid(gui, 9 + i * 20, 73, i >= stacks.size() ? FluidStack.EMPTY : stacks.get(i));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttons.clear();
        this.redstoneButton = new WootRedstoneButton(this.f_97735_ + 152, this.f_97736_ + 57, RedstoneMode.ALWAYS_ON, button -> {
            RedstoneMode mode = button.nextMode();
            FakeSpawnerBlockEntity entity = ((HeartContainerMenu)this.f_97732_).getFakeSpawner(this.buttons.get(this.activeButton).getFakeSpawnerIndex());
            entity.setRedstoneMode(mode);
            entity.sendNewState();
        });
        this.m_142416_((GuiEventListener)this.redstoneButton);
        this.redstoneButton.f_93623_ = false;
        this.createButton(8, 17, 0);
        this.createButton(130, 17, 1);
        this.createButton(90, 17, 2);
        this.createButton(50, 17, 3);
        if (this.activeButton != -1) {
            this.buttons.get((int)this.activeButton).isViewActive = true;
        }
    }

    protected void createButton(int x, int y, int fakeSpawnerIndex) {
        this.addRenderableWidget(new WootHeartInputButton(fakeSpawnerIndex, this.f_97735_ + x, this.f_97736_ + y, this::setButtonActive));
    }

    public void setButtonActive(WootHeartInputButton button) {
        if (this.activeButton == button.index) {
            this.activeButton = -1;
            button.isViewActive = false;
            this.redstoneButton.f_93623_ = false;
        } else {
            if (this.activeButton != -1) {
                this.buttons.get((int)this.activeButton).isViewActive = false;
            }
            this.activeButton = button.index;
            button.isViewActive = true;
            this.redstoneButton.f_93623_ = true;
            this.redstoneButton.setMode(((HeartContainerMenu)this.f_97732_).getFakeSpawner(this.buttons.get(this.activeButton).getFakeSpawnerIndex()).getRedstoneMode());
        }
    }

    protected void updateButton(int fakeSpawnerIndex) {
        WootFactoryMob<?> mob = ((HeartContainerMenu)this.f_97732_).getFactoryMob(fakeSpawnerIndex);
        this.buttons.get((int)fakeSpawnerIndex).f_93623_ = mob != null && this.isTierEntityValid(mob);
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((HeartContainerMenu)this.f_97732_).f_38839_) {
            if (slot instanceof WootSlot) {
                WootSlot wootSlot = (WootSlot)slot;
                wootSlot.setActive(this.activeButton == -1);
                continue;
            }
            if (!(slot instanceof WootSlotItemHandler)) continue;
            WootSlotItemHandler wootSlotItemHandler = (WootSlotItemHandler)slot;
            if (wootSlotItemHandler.getType() == WootSlotItemHandler.Type.INVENTORY) {
                wootSlotItemHandler.setActive(this.activeButton == -1);
                continue;
            }
            wootSlotItemHandler.setActive(this.activeButton != -1);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        super.m_280072_(gui, mouseX, mouseY);
        this.m_280072_(gui, mouseX, mouseY);
        for (WootButton wootButton : this.buttons) {
            wootButton.m_88315_(gui, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7286_(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(gui);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        gui.m_280218_(GUI, 0, 0, 0, 0, this.f_97726_, this.f_97727_);
        this.renderMenuBackground(gui);
        this.renderState(gui);
        if (this.activeButton != -1 && ((HeartContainerMenu)this.f_97732_).getFactoryMob(this.activeButton) == null) {
            this.buttons.get((int)this.activeButton).isViewActive = false;
            this.activeButton = -1;
        }
        if (this.activeButton != -1) {
            this.renderFakeSpawner(gui);
        }
        pose.m_85849_();
    }

    protected void m_280003_(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        int titleX = 1 + (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        gui.m_280614_(this.f_96547_, this.f_96539_, titleX, 6, 0x404040, false);
    }

    protected void renderFluidBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 39, 185, 18, 41);
    }

    protected void renderFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        int fillHeight = Mth.m_14045_((int)(fluid.getAmount() * 35 / capacity), (int)0, (int)35);
        int fillY = 35 - fillHeight;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + fillY + 3, 12, fillHeight, fluidTypeExtensions.getTintColor(), false);
        gui.m_280218_(GUI, x + 3, y + 3, 42, 188, 12, 35);
    }

    protected void renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity) {
        if (this.m_6774_(x, y, 18, 41, mouseX, mouseY)) {
            List<MutableComponent> tooltip = capacity == 0 ? List.of(Component.m_237115_((String)"gui.woot_revived.heart.vitality_cell_missing").m_6270_(WootStyles.MACHINE_STYLE)) : List.of(Component.m_237115_((String)"gui.woot_revived.heart.vitality_cell").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(capacity)).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
            gui.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderSmallFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + 3, 12, 13, fluidTypeExtensions.getTintColor(), false);
        gui.m_280218_(GUI, x + 3, y + 3, 61, 188, 12, 13);
    }

    protected void renderSmallFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid) {
        if (this.m_6774_(x + 1, y + 1, 16, 17, mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(List.of(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.fluid").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.m_237115_((String)"info.woot_revived.empty"))), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(fluid.getAmount())).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE))));
            if (fluid != null && !fluid.isEmpty()) {
                String modId = ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).m_135827_();
                tooltip.add(ModNameHelper.getModName(modId).m_6270_(WootStyles.MOD_NAME_STYLE));
            }
            gui.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Nullable
    protected LivingEntity getLivingEntity(int fakeSpawnerIndex) {
        CompoundTag tag = ((HeartContainerMenu)this.f_97732_).getFactoryMobTag(fakeSpawnerIndex);
        if (tag == null) {
            return null;
        }
        Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)((HeartContainerMenu)this.f_97732_).getLevel(), e -> e);
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    protected boolean isTierEntityValid(@NotNull LivingEntity entity) {
        Tier tier = ((HeartContainerMenu)this.f_97732_).getFactoryTier();
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entity.m_20078_());
        return tier.isMobTierValid(mob.getTier());
    }

    protected boolean isTierEntityValid(@NotNull WootFactoryMob<?> mob) {
        Tier tier = ((HeartContainerMenu)this.f_97732_).getFactoryTier();
        return tier.isMobTierValid(mob.getTier());
    }

    protected void renderEntityBoxBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.m_280218_(GUI, x, y, 0, 185, 38, 38);
    }

    protected void renderEntityBox(@NotNull GuiGraphics gui, int x, int y, @Nullable LivingEntity entity) {
        if (entity == null || !this.isTierEntityValid(entity)) {
            MutableComponent invalid = Component.m_237115_((String)"info.woot_revived.factory.invalid");
            MutableComponent empty = Component.m_237115_((String)"info.woot_revived.factory.empty");
            Tier tier = ((HeartContainerMenu)this.f_97732_).getFactoryTier();
            float scale = 0.65f;
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_85841_(scale, scale, scale);
            float f = (int)BOX_SIZE;
            Objects.requireNonNull(this.f_96547_);
            float drawY = (f - 9.0f * scale) / 2.0f;
            if (tier == Tier.INVALID || tier == Tier.TIER_1 || entity != null && !this.isTierEntityValid(entity)) {
                float drawX = ((float)((int)BOX_SIZE) - (float)this.f_96547_.m_92852_((FormattedText)invalid) * scale) / 2.0f;
                pose.m_252880_(((float)x + drawX + 3.25f) / scale, ((float)y + drawY + 3.25f) / scale, 0.0f);
                gui.m_280614_(this.f_96547_, (Component)invalid, 0, 0, 0x404040, false);
            } else {
                float drawX = ((float)((int)BOX_SIZE) - (float)this.f_96547_.m_92852_((FormattedText)empty) * scale) / 2.0f;
                pose.m_252880_(((float)x + drawX + 3.25f) / scale, ((float)y + drawY + 3.25f) / scale, 0.0f);
                gui.m_280614_(this.f_96547_, (Component)empty, 0, 0, 0x404040, false);
            }
            pose.m_85849_();
            return;
        }
        WootEntityRenderer.render(gui, x, y, entity, BOX_SIZE, BOX_PADDING, MAX_ENTITY_BOX_SIZE);
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)((FluidType)FluidsRegistry.VITALITY_FUEL_FLUID_TYPE.get()));
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + (int)BOX_PADDING, y + (int)BOX_PADDING, (int)BOX_SIZE, (int)BOX_SIZE, fluidTypeExtensions.getTintColor(), true);
    }

    protected void renderEntityTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fakeSpawnerIndex) {
        if (this.m_6774_(x + 1, y + 1, 36, 36, mouseX, mouseY)) {
            List<MutableComponent> tooltip;
            WootFactoryMob<?> mob = ((HeartContainerMenu)this.f_97732_).getFactoryMob(fakeSpawnerIndex);
            @Nullable CompoundTag tag = ((HeartContainerMenu)this.f_97732_).getFactoryMobTag(fakeSpawnerIndex);
            Tier tier = ((HeartContainerMenu)this.f_97732_).getFactoryTier();
            if (mob == null || !this.isTierEntityValid(mob)) {
                tooltip = tier == Tier.INVALID ? List.of(Component.m_237115_((String)"gui.woot_revived.heart.no_tier")) : (tier == Tier.TIER_1 && mob == null ? List.of(Component.m_237110_((String)"gui.woot_revived.heart.insufficient_tier", (Object[])new Object[]{Component.m_237115_((String)WootTier.getTranslationKey(Tier.TIER_2))})) : (mob == null ? List.of(Component.m_237115_((String)"gui.woot_revived.heart.no_secondary")) : List.of(Component.m_237110_((String)"gui.woot_revived.heart.insufficient_tier", (Object[])new Object[]{Component.m_237115_((String)WootTier.getTranslationKey(mob.getTier()))}))));
            } else {
                tooltip = new ArrayList<MutableComponent>();
                tooltip.add(mob.getDisplayName(tag, (HolderLookup.Provider)((HeartContainerMenu)this.f_97732_).getLevel().m_9598_()).m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE));
                tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.tier").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)Component.m_237115_((String)WootTier.getTranslationKey(mob.getTier()))));
                tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.rate").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(mob.getSpawnTickRate())).m_7220_((Component)Component.m_237113_((String)"t").m_6270_(WootStyles.UNIT_STYLE)));
                tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.cost").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(mob.getVitalityFuelCost())).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
                String modId = ForgeRegistries.ENTITY_TYPES.getKey(mob.getEntityType()).m_135827_();
                tooltip.add(ModNameHelper.getModName(modId).m_6270_(WootStyles.MOD_NAME_STYLE));
                if (((HeartContainerMenu)this.f_97732_).getFactoryIsActive(fakeSpawnerIndex)) {
                    tooltip.add(Component.m_237119_());
                    tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.drained").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(((HeartContainerMenu)this.f_97732_).getFactoryVitalityDrained(fakeSpawnerIndex))).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(((HeartContainerMenu)this.f_97732_).getFactoryVitalityAmount(fakeSpawnerIndex))).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
                    tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.eta").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(String.format("%.1f", Float.valueOf(((HeartContainerMenu)this.f_97732_).getFactoryETA(fakeSpawnerIndex)))).m_7220_((Component)Component.m_237113_((String)"s").m_6270_(WootStyles.UNIT_STYLE)));
                    tooltip.add(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.usage").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatFloat(((HeartContainerMenu)this.f_97732_).getFactoryRate(fakeSpawnerIndex))).m_7220_((Component)Component.m_237113_((String)" mB").m_6270_(WootStyles.UNIT_STYLE)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)Component.m_237113_((String)"t").m_6270_(WootStyles.UNIT_STYLE)));
                }
            }
            gui.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

