/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.sprite.factory_upgrade;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.mixins.impl.SpriteSourcesMixin;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public class FactoryUpgradeDynamicSpriteSource
implements SpriteSource {
    private final Atlas atlas;

    public FactoryUpgradeDynamicSpriteSource(Atlas atlas) {
        this.atlas = atlas;
    }

    public void m_260891_(@NotNull ResourceManager resourceManager, @NotNull SpriteSource.Output output) {
        Collection<RegistryObject<? extends WootUpgradeItem>> upgradeItems = UpgradeItemsRegistry.getValues();
        ResourceLocation factoryUpgradeResourceLocation = Woot.location("textures/block/factory_upgrade.png");
        Resource factoryResource = this.getResource(resourceManager, factoryUpgradeResourceLocation);
        LazyLoadedImage factoryImage = new LazyLoadedImage(factoryUpgradeResourceLocation, factoryResource, upgradeItems.size());
        for (RegistryObject<? extends WootUpgradeItem> upgradeItem : upgradeItems) {
            ResourceLocation upgradeItemResourceLocation = ((WootUpgradeItem)((Object)upgradeItem.get())).getTextureLocation();
            Resource upgradeItemResource = this.getResource(resourceManager, upgradeItemResourceLocation);
            LazyLoadedImage upgradeItemImage = new LazyLoadedImage(upgradeItemResourceLocation, upgradeItemResource, 1);
            ResourceLocation spriteLocation = Woot.location("block/upgrade_item_" + UpgradeItemsRegistry.getNameFromItem(upgradeItem));
            output.m_260840_(spriteLocation, (SpriteSource.SpriteSupplier)new UpgradeSpriteSupplier((WootUpgradeItem)((Object)upgradeItem.get()), factoryImage, upgradeItemImage, spriteLocation));
        }
    }

    private Resource getResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Optional optionalResource = resourceManager.m_213713_(resourceLocation);
        if (optionalResource.isPresent()) {
            return (Resource)optionalResource.get();
        }
        throw new RuntimeException("Could not find resource: " + String.valueOf(resourceLocation));
    }

    @NotNull
    public SpriteSourceType m_260850_() {
        return this.atlas.type;
    }

    public static void register() {
        Atlas.register();
    }

    public static enum Atlas {
        BLOCKS;

        private final SpriteSourceType type;

        private Atlas() {
            Codec CODEC = Codec.unit(() -> new FactoryUpgradeDynamicSpriteSource(this));
            this.type = SpriteSourcesMixin.woot$register("woot_revived:factory_upgrade", (Codec<? extends SpriteSource>)CODEC);
        }

        private static void register() {
        }
    }

    public record UpgradeSpriteSupplier(WootUpgradeItem upgradeItem, LazyLoadedImage lazyFactoryImage, LazyLoadedImage lazyUpgradeImage, ResourceLocation location) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents get() {
            try {
                NativeImage factoryUpgradeImage = this.lazyFactoryImage.m_266167_();
                NativeImage upgradeItemImage = this.lazyUpgradeImage.m_266167_();
                NativeImage imageSide = new NativeImage(factoryUpgradeImage.m_84982_(), factoryUpgradeImage.m_85084_(), false);
                imageSide.m_85054_(factoryUpgradeImage);
                this.upgradeItem.applyUpgradeTexture(imageSide, upgradeItemImage);
                SpriteContents spriteContents = new SpriteContents(this.location, new FrameSize(imageSide.m_84982_(), imageSide.m_85084_()), imageSide, AnimationMetadataSection.f_119012_, null);
                return spriteContents;
            }
            catch (IOException iOException) {
            }
            finally {
                this.m_260986_();
            }
            return null;
        }

        public void m_260986_() {
            this.lazyFactoryImage.m_266458_();
            this.lazyUpgradeImage.m_266458_();
        }
    }
}

