/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import wootrevived.api.WootFactoryMob;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.events.InitDropSimulator;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.helper.SerializeEntityNBTHelper;

public class GiveCommand {
    private static final SuggestionProvider<CommandSourceStack> suggestionProvider = (commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82926_(InitDropSimulator.mobLocations, (SuggestionsBuilder)suggestionsBuilder);

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(suggestionProvider).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"entity"), new CompoundTag()))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"entity"), CompoundTagArgument.m_87660_((CommandContext)ctx, (String)"nbt"))))));
    }

    private static int giveItem(CommandSourceStack source, ServerPlayer target, ResourceLocation resourceLocation, CompoundTag tag) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        if (entityType == null || !WootFactoryMobsRegistry.hasFactoryMob(entityType)) {
            return 1;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entityType);
        if (mob.isBlacklisted()) {
            return 1;
        }
        tag.m_128359_("id", resourceLocation.toString());
        EntityType.m_20642_((CompoundTag)tag, (Level)source.m_81372_()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
            CompoundTag mobTag = mob.saveTag(SerializeEntityNBTHelper.serialize((Entity)entity), (HolderLookup.Provider)source.m_81372_().m_9598_());
            ItemStack fakeSpawner = FakeSpawnerBlockEntity.getItemStack(mobTag);
            ItemHandlerHelper.giveItemToPlayer((Player)target, (ItemStack)fakeSpawner);
        });
        return 1;
    }
}

