/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei;

import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootStyles;

public class WootJeiCustomFluidRenderer
implements IIngredientRenderer<FluidStack> {
    private final int capacity;

    public WootJeiCustomFluidRenderer(int capacity) {
        this.capacity = capacity;
    }

    public void render(@NotNull GuiGraphics gui, @NotNull FluidStack ingredient) {
        WootContainerScreen.renderFluid(gui, -3, -3, ingredient, this.capacity);
    }

    @NotNull
    public List<Component> getTooltip(FluidStack ingredient, @NotNull TooltipFlag tooltipFlag) {
        return List.of(Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.fluid").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_7220_((Component)(ingredient != null && !ingredient.isEmpty() ? ingredient.getDisplayName() : Component.m_237115_((String)"info.woot_revived.empty"))), Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"info.woot_revived.amount").m_7220_((Component)Component.m_237113_((String)": ")).m_6270_(WootStyles.MACHINE_STYLE)).m_130946_(WootContainerScreen.formatInteger(ingredient.getAmount())).m_7220_((Component)Component.m_237113_((String)"mB").m_6270_(WootStyles.UNIT_STYLE)));
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 50;
    }
}

