/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.Woot;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.compat.jei.categories.DyeLiquifierRecipeCategory;
import wootrevived.woot.compat.jei.categories.EnchantedLiquifierRecipeCategory;
import wootrevived.woot.compat.jei.categories.FluidInfuserRecipeCategory;
import wootrevived.woot.compat.jei.categories.ItemInfuserRecipeCategory;
import wootrevived.woot.compat.jei.categories.StygianAnvilRecipeCategory;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.items.basic.BasicItem;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.recipes.enchanted_liquifier.EnchantedLiquifierRecipe;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.ItemsRegistry;

@JeiPlugin
public class WootJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Woot.location("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new StygianAnvilRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DyeLiquifierRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FluidInfuserRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new ItemInfuserRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new EnchantedLiquifierRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.m_7465_();
        ArrayList<StygianAnvilRecipe> stygianAnvilRecipes = new ArrayList<StygianAnvilRecipe>();
        ArrayList<DyeLiquifierRecipe> dyeLiquifierRecipes = new ArrayList<DyeLiquifierRecipe>();
        ArrayList<FluidInfuserRecipe> fluidInfuserRecipes = new ArrayList<FluidInfuserRecipe>();
        ArrayList<ItemInfuserRecipe> itemInfuserRecipes = new ArrayList<ItemInfuserRecipe>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            if (recipe instanceof StygianAnvilRecipe) {
                StygianAnvilRecipe stygianAnvilRecipe = (StygianAnvilRecipe)recipe;
                stygianAnvilRecipes.add(stygianAnvilRecipe);
                continue;
            }
            if (recipe instanceof DyeLiquifierRecipe) {
                DyeLiquifierRecipe dyeLiquifierRecipe = (DyeLiquifierRecipe)recipe;
                dyeLiquifierRecipes.add(dyeLiquifierRecipe);
                continue;
            }
            if (recipe instanceof FluidInfuserRecipe) {
                FluidInfuserRecipe fluidInfuserRecipe = (FluidInfuserRecipe)recipe;
                fluidInfuserRecipes.add(fluidInfuserRecipe);
                continue;
            }
            if (!(recipe instanceof ItemInfuserRecipe)) continue;
            ItemInfuserRecipe itemInfuserRecipe = (ItemInfuserRecipe)recipe;
            itemInfuserRecipes.add(itemInfuserRecipe);
        }
        registration.addRecipes(WootJeiPluginTypes.STYGIAN_ANVIL_TYPE, stygianAnvilRecipes);
        registration.addRecipes(WootJeiPluginTypes.DYE_LIQUIFIER_TYPE, dyeLiquifierRecipes);
        registration.addRecipes(WootJeiPluginTypes.FLUID_INFUSER_TYPE, fluidInfuserRecipes);
        registration.addRecipes(WootJeiPluginTypes.ITEM_INFUSER_TYPE, itemInfuserRecipes);
        ArrayList<EnchantedLiquifierRecipe> enchantedLiquifierRecipes = new ArrayList<EnchantedLiquifierRecipe>();
        HashMap<Integer, List> booksMap = new HashMap<Integer, List>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            for (int enchantLevel = enchantment.m_44702_(); enchantLevel <= enchantment.m_6586_(); ++enchantLevel) {
                ItemStack itemStack = Items.f_42690_.m_7968_();
                itemStack.m_41663_(enchantment, enchantLevel);
                enchantLevel = Mth.m_14045_((int)enchantLevel, (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get()));
                booksMap.computeIfAbsent(enchantLevel, k -> new ArrayList());
                ((List)booksMap.get(enchantLevel)).add(itemStack);
            }
        }
        for (Integer enchantLevel : booksMap.keySet()) {
            List books = (List)booksMap.get(enchantLevel);
            Ingredient ingredient = Ingredient.m_43921_(books.stream());
            int amount = enchantLevel * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_FLUID.get();
            int energy = enchantLevel * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_ENERGY.get();
            enchantedLiquifierRecipes.add(new EnchantedLiquifierRecipe(energy, ingredient, new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount)));
        }
        registration.addRecipes(WootJeiPluginTypes.ENCHANTED_LIQUIFIER_TYPE, enchantedLiquifierRecipes);
        registration.addItemStackInfo(List.of(((BasicItem)((Object)ItemsRegistry.IRON_SHARD_ITEM.get())).m_7968_(), ((BasicItem)((Object)ItemsRegistry.GOLD_SHARD_ITEM.get())).m_7968_(), ((BasicItem)((Object)ItemsRegistry.DIAMOND_SHARD_ITEM.get())).m_7968_(), ((BasicItem)((Object)ItemsRegistry.NETHERITE_SHARD_ITEM.get())).m_7968_()), new Component[]{Component.m_237115_((String)"jei.woot_revived.shard")});
        registration.addIngredientInfo((ItemLike)BlocksRegistry.STYGIAN_ANVIL_BLOCK.get(), new Component[]{Component.m_237115_((String)"jei.woot_revived.anvil.0"), Component.m_237115_((String)"jei.woot_revived.anvil.1"), Component.m_237115_((String)"jei.woot_revived.anvil.2"), Component.m_237115_((String)"jei.woot_revived.anvil.3")});
        registration.addItemStackInfo(((MobShardItem)((Object)ItemsRegistry.MOB_SHARD_ITEM.get())).m_7968_(), new Component[]{Component.m_237115_((String)"jei.woot_revived.mob_shard.0"), Component.m_237115_((String)"jei.woot_revived.mob_shard.1"), Component.m_237115_((String)"jei.woot_revived.mob_shard.2")});
        registration.addItemStackInfo(((BucketItem)FluidsRegistry.PURE_DYE_FLUID_BUCKET.get()).m_7968_(), new Component[]{Component.m_237110_((String)"jei.woot_revived.pure_dye_fluid", (Object[])new Object[]{DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()})});
        registration.addIngredientInfo((Object)new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), 1), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{Component.m_237110_((String)"jei.woot_revived.pure_dye_fluid", (Object[])new Object[]{DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get(), DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()})});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)BlocksRegistry.STYGIAN_ANVIL_BLOCK.get(), new RecipeType[]{WootJeiPluginTypes.STYGIAN_ANVIL_TYPE});
        registration.addRecipeCatalyst((ItemLike)BlocksRegistry.DYE_LIQUIFIER_BLOCK.get(), new RecipeType[]{WootJeiPluginTypes.DYE_LIQUIFIER_TYPE});
        registration.addRecipeCatalyst((ItemLike)BlocksRegistry.FLUID_INFUSER_BLOCK.get(), new RecipeType[]{WootJeiPluginTypes.FLUID_INFUSER_TYPE});
        registration.addRecipeCatalyst((ItemLike)BlocksRegistry.ITEM_INFUSER_BLOCK.get(), new RecipeType[]{WootJeiPluginTypes.ITEM_INFUSER_TYPE});
        registration.addRecipeCatalyst((ItemLike)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK.get(), new RecipeType[]{WootJeiPluginTypes.ENCHANTED_LIQUIFIER_TYPE});
    }
}

